/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.domain;

import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavFile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;

public class DavTempFile
extends AbstractDavFile {
    private byte[] data;

    public void init(XWikiDavResource parent, String name, String relativePath) throws DavException {
        super.init(parent, name, relativePath);
        if (!name.startsWith(".")) {
            throw new DavException(500);
        }
        Date currentDate = new Date();
        String timeStamp = DavConstants.creationDateFormat.format(currentDate);
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)timeStamp));
        timeStamp = DavConstants.modificationDateFormat.format(currentDate);
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)timeStamp));
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETETAG, (Object)timeStamp));
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLANGUAGE, (Object)"en"));
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTTYPE, (Object)"application/octet-stream"));
        int contentLength = this.exists() ? this.data.length : 0;
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)contentLength));
    }

    public void setdData(byte[] data) {
        this.data = data;
    }

    public boolean exists() {
        return this.data != null;
    }

    public void spool(OutputContext outputContext) throws IOException {
        OutputStream out;
        if (this.exists() && (out = outputContext.getOutputStream()) != null) {
            out.write(this.data);
            out.flush();
        }
    }

    public void move(DavResource destination) throws DavException {
        throw new DavException(501);
    }

    public void copy(DavResource destination, boolean shallow) throws DavException {
        throw new DavException(501);
    }

    public MultiStatusResponse alterProperties(List changeList) throws DavException {
        throw new DavException(501);
    }

    public MultiStatusResponse alterProperties(DavPropertySet setProperties, DavPropertyNameSet removePropertyNames) throws DavException {
        throw new DavException(501);
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
        throw new DavException(501);
    }

    public void setProperty(DavProperty property) throws DavException {
        throw new DavException(501);
    }

    public long getModificationTime() {
        return -1L;
    }

    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD, PROPFIND, LOCK, UNLOCK";
    }
}

