/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.partial;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockDiscovery;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.SupportedLock;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDavResource
implements XWikiDavResource {
    protected DavResourceLocator locator;
    protected DavResourceFactory factory;
    protected DavSession session;
    protected DavPropertySet davPropertySet = new DavPropertySet();
    protected XWikiContext xwikiContext;
    protected LockManager lockManager;
    protected XWikiDavResource parentResource;
    protected String name;

    @Override
    public void init(XWikiDavResource parent, String name, String relativePath) throws DavException {
        this.locator = parent.getLocator().getFactory().createResourceLocator(parent.getLocator().getPrefix(), parent.getLocator().getWorkspacePath(), parent.getLocator().getResourcePath() + relativePath);
        this.factory = parent.getFactory();
        this.session = parent.getSession();
        this.lockManager = parent.getLockManager();
        this.xwikiContext = parent.getXwikiContext();
        this.parentResource = parent;
        this.name = name;
        this.initProperties();
    }

    @Override
    public void init(String name, DavResourceLocator locator, DavResourceFactory factory, DavSession session, LockManager lockManager, XWikiContext xwikiContext) throws DavException {
        this.locator = locator;
        this.factory = factory;
        this.session = session;
        this.lockManager = lockManager;
        this.xwikiContext = xwikiContext;
        this.name = name;
        this.initProperties();
    }

    public void initProperties() {
        String timeStamp = DavConstants.creationDateFormat.format(new Date());
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)timeStamp));
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.SOURCE, (Object)(this.locator.getPrefix() + this.getResourcePath())));
        if (this.getDisplayName() != null) {
            this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.DISPLAYNAME, (Object)this.getDisplayName()));
        }
        if (this.isCollection()) {
            this.davPropertySet.add((DavProperty)new ResourceType(1));
            this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)"1"));
        } else {
            this.davPropertySet.add((DavProperty)new ResourceType(0));
            this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)"0"));
        }
        this.davPropertySet.add((DavProperty)new LockDiscovery(this.getLock(Type.WRITE, Scope.EXCLUSIVE)));
        SupportedLock supportedLock = new SupportedLock();
        supportedLock.addEntry(Type.WRITE, Scope.EXCLUSIVE);
        this.davPropertySet.add((DavProperty)supportedLock);
    }

    @Override
    public List<XWikiDavResource> getSessionResources() {
        HttpSession httpSession = this.xwikiContext.getRequest().getSession();
        if (httpSession.getAttribute(this.getResourcePath()) == null) {
            httpSession.setAttribute(this.getResourcePath(), new ArrayList());
        }
        return (List)httpSession.getAttribute(this.getResourcePath());
    }

    public DavPropertySet getProperties() {
        return this.davPropertySet;
    }

    public DavProperty getProperty(DavPropertyName name) {
        return this.getProperties().get(name);
    }

    public DavPropertyName[] getPropertyNames() {
        return this.getProperties().getPropertyNames();
    }

    public boolean isLockable(Type type, Scope scope) {
        return Type.WRITE.equals((Object)type) && Scope.EXCLUSIVE.equals((Object)scope);
    }

    public ActiveLock getLock(Type type, Scope scope) {
        return this.lockManager.getLock(type, scope, (DavResource)this);
    }

    public ActiveLock[] getLocks() {
        ActiveLock[] activeLockArray;
        ActiveLock writeLock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (writeLock != null) {
            ActiveLock[] activeLockArray2 = new ActiveLock[1];
            activeLockArray = activeLockArray2;
            activeLockArray2[0] = writeLock;
        } else {
            activeLockArray = new ActiveLock[]{};
        }
        return activeLockArray;
    }

    public boolean hasLock(Type type, Scope scope) {
        return this.getLock(type, scope) != null;
    }

    public ActiveLock lock(LockInfo reqLockInfo) throws DavException {
        ActiveLock lock = null;
        if (!this.isLockable(reqLockInfo.getType(), reqLockInfo.getScope())) {
            throw new DavException(412);
        }
        lock = this.lockManager.createLock(reqLockInfo, (DavResource)this);
        return lock;
    }

    public ActiveLock refreshLock(LockInfo reqLockInfo, String lockToken) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        ActiveLock lock = this.getLock(reqLockInfo.getType(), reqLockInfo.getScope());
        if (lock == null) {
            throw new DavException(412);
        }
        return this.lockManager.refreshLock(reqLockInfo, lockToken, (DavResource)this);
    }

    public void unlock(String lockToken) throws DavException {
        ActiveLock lock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (lock == null) {
            throw new DavException(412);
        }
        if (!lock.isLockedByToken(lockToken)) {
            throw new DavException(423);
        }
        this.lockManager.releaseLock(lockToken, (DavResource)this);
    }

    public void addLockManager(LockManager lockmgr) {
        this.lockManager = lockmgr;
    }

    public String getComplianceClass() {
        return "1, 2";
    }

    public DavResourceFactory getFactory() {
        return this.factory;
    }

    public DavResourceLocator getLocator() {
        return this.locator;
    }

    public String getResourcePath() {
        return this.locator.getResourcePath();
    }

    public DavSession getSession() {
        return this.session;
    }

    public DavResource getCollection() {
        return this.parentResource;
    }

    @Override
    public XWikiContext getXwikiContext() {
        return this.xwikiContext;
    }

    @Override
    public LockManager getLockManager() {
        return this.lockManager;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DavResource) {
            DavResource other = (DavResource)obj;
            return this.getResourcePath().equals(other.getResourcePath());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

