/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.views.attachments;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavView;
import com.xpn.xwiki.plugin.webdav.resources.views.attachments.AttachmentsByFirstLettersSubView;
import com.xpn.xwiki.plugin.webdav.utils.XWikiDavUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentsBySpaceNameSubView
extends AbstractDavView {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentsBySpaceNameSubView.class);

    @Override
    public void decode(Stack<XWikiDavResource> stack, String[] tokens, int next) throws DavException {
        if (next < tokens.length) {
            String token = tokens[next];
            if (token.startsWith("_") && token.endsWith("_")) {
                AttachmentsByFirstLettersSubView subView = new AttachmentsByFirstLettersSubView();
                subView.init(this, token.toUpperCase(), "/" + token.toUpperCase());
                stack.push(subView);
                subView.decode(stack, tokens, next + 1);
            } else {
                throw new DavException(400);
            }
        }
    }

    public DavResourceIterator getMembers() {
        ArrayList<AttachmentsByFirstLettersSubView> children = new ArrayList<AttachmentsByFirstLettersSubView>();
        try {
            String sql = ", XWikiAttachment as attach where doc.id = attach.docId and doc.web = '" + this.getDisplayName() + "'";
            List docNames = this.xwikiContext.getWiki().getStore().searchDocumentsNames(sql, 0, 0, this.xwikiContext);
            HashSet<String> subViewNames = new HashSet<String>();
            int subViewNameLength = XWikiDavUtils.getSubViewNameLength(docNames.size());
            for (String docName : docNames) {
                int dot;
                String pageName = docName.substring((dot = docName.lastIndexOf(46)) + 1);
                if (subViewNameLength < pageName.length()) {
                    subViewNames.add(pageName.substring(0, subViewNameLength).toUpperCase());
                    continue;
                }
                subViewNames.add(pageName.toUpperCase());
            }
            for (String subViewName : subViewNames) {
                try {
                    String modName = "_" + subViewName + "_";
                    AttachmentsByFirstLettersSubView subView = new AttachmentsByFirstLettersSubView();
                    subView.init(this, modName, "/" + modName);
                    children.add(subView);
                }
                catch (DavException e) {
                    LOG.error("Unexpected Error : ", (Throwable)e);
                }
            }
        }
        catch (XWikiException e) {
            LOG.error("Unexpected Error : ", (Throwable)e);
        }
        return new DavResourceIteratorImpl(children);
    }

    public void addMember(DavResource member, InputContext inputContext) throws DavException {
        throw new DavException(405);
    }

    public void removeMember(DavResource member) throws DavException {
        throw new DavException(405);
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD, PROPFIND, LOCK, UNLOCK";
    }
}

