/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.views.pages;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavView;
import com.xpn.xwiki.plugin.webdav.resources.views.pages.PagesBySpaceNameSubView;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagesView
extends AbstractDavView {
    private static final Logger LOG = LoggerFactory.getLogger(PagesView.class);

    @Override
    public void decode(Stack<XWikiDavResource> stack, String[] tokens, int next) throws DavException {
        if (next < tokens.length) {
            String spaceName = tokens[next];
            PagesBySpaceNameSubView subView = new PagesBySpaceNameSubView();
            subView.init(this, spaceName, "/" + spaceName);
            stack.push(subView);
            subView.decode(stack, tokens, next + 1);
        }
    }

    public DavResourceIterator getMembers() {
        ArrayList<PagesBySpaceNameSubView> children = new ArrayList<PagesBySpaceNameSubView>();
        try {
            List spaceNames = this.xwikiContext.getWiki().getSpaces(this.xwikiContext);
            for (String spaceName : spaceNames) {
                PagesBySpaceNameSubView subView = new PagesBySpaceNameSubView();
                subView.init(this, spaceName, "/" + spaceName);
                children.add(subView);
            }
        }
        catch (XWikiException e) {
            LOG.error("Unexpected Error : ", (Throwable)e);
        }
        catch (DavException e) {
            LOG.error("Unexpected Error : ", (Throwable)e);
        }
        return new DavResourceIteratorImpl(children);
    }

    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        PagesBySpaceNameSubView space = (PagesBySpaceNameSubView)resource;
        try {
            XWikiDocument doc = this.xwikiContext.getWiki().getDocument(space.getDisplayName() + ".WebHome", this.xwikiContext);
            doc.setContent("This page was created thorugh xwiki-webdav interface.");
            this.xwikiContext.getWiki().saveDocument(doc, this.xwikiContext);
        }
        catch (XWikiException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    public void removeMember(DavResource member) throws DavException {
        PagesBySpaceNameSubView space = (PagesBySpaceNameSubView)member;
        try {
            List docNames = this.xwikiContext.getWiki().getStore().searchDocumentsNames("where doc.web='" + space.getDisplayName() + "'", 0, 0, this.xwikiContext);
            for (String docName : docNames) {
                XWikiDocument doc = this.xwikiContext.getWiki().getDocument(docName, this.xwikiContext);
                this.xwikiContext.getWiki().deleteDocument(doc, this.xwikiContext);
            }
        }
        catch (XWikiException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD, POST, PROPFIND, MKCOL, PUT, LOCK, UNLOCK";
    }
}

