/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.utils;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.views.RootView;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiEngineContext;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import com.xpn.xwiki.web.XWikiServletContext;
import com.xpn.xwiki.web.XWikiServletRequest;
import com.xpn.xwiki.web.XWikiURLFactory;
import com.xpn.xwiki.xmlrpc.XWikiXmlRpcResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.xwiki.container.servlet.ServletContainerException;
import org.xwiki.container.servlet.ServletContainerInitializer;

public class XWikiDavResourceFactory
implements DavResourceFactory {
    private XWikiContext xwikiContext;
    private final LockManager lockManager;
    private ServletContext servletContext;

    public XWikiDavResourceFactory(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public DavResource createResource(DavResourceLocator locator, DavServletRequest request, DavServletResponse response) throws DavException {
        return this.createResource(locator, request.getDavSession(), request, response);
    }

    public DavResource createResource(DavResourceLocator locator, DavSession session) throws DavException {
        return this.createResource(locator, session, null, null);
    }

    public XWikiDavResource createResource(DavResourceLocator locator, DavSession session, DavServletRequest request, DavServletResponse response) throws DavException {
        DavResourceLocator rootLocator = locator.getFactory().createResourceLocator(locator.getPrefix(), "/webdav", "/webdav");
        try {
            this.initXWikiContext(request, response, this.servletContext);
        }
        catch (XWikiException e) {
            throw new DavException(500, (Throwable)e);
        }
        RootView rootView = (RootView)Utils.getComponent((String)XWikiDavResource.ROLE, (String)"root");
        rootView.init("webdav", rootLocator, this, session, this.lockManager, this.xwikiContext);
        return rootView.decode(locator);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private void initXWikiContext(DavServletRequest drequest, DavServletResponse dresponse, ServletContext servletContext) throws XWikiException {
        XWikiServletContext xwikiEngine = new XWikiServletContext(servletContext);
        XWikiServletRequest xwikiRequest = new XWikiServletRequest((HttpServletRequest)drequest);
        XWikiXmlRpcResponse xwikiResponse = new XWikiXmlRpcResponse((HttpServletResponse)dresponse);
        this.xwikiContext = Utils.prepareContext((String)"", (XWikiRequest)xwikiRequest, (XWikiResponse)xwikiResponse, (XWikiEngineContext)xwikiEngine);
        this.xwikiContext.setMode(5);
        this.xwikiContext.setDatabase("xwiki");
        ServletContainerInitializer containerInitializer = (ServletContainerInitializer)Utils.getComponent((String)ServletContainerInitializer.ROLE);
        try {
            containerInitializer.initializeRequest(this.xwikiContext.getRequest().getHttpServletRequest(), (Object)this.xwikiContext);
            containerInitializer.initializeResponse(this.xwikiContext.getResponse().getHttpServletResponse());
            containerInitializer.initializeSession(this.xwikiContext.getRequest().getHttpServletRequest());
            containerInitializer.initializeApplicationContext(servletContext);
        }
        catch (ServletContainerException e) {
            throw new XWikiException(5, 3, "Failed to initialize Request/Response or Session", (Throwable)e);
        }
        XWiki xwiki = XWiki.getXWiki((XWikiContext)this.xwikiContext);
        XWikiURLFactory urlf = xwiki.getURLFactoryService().createURLFactory(this.xwikiContext.getMode(), this.xwikiContext);
        this.xwikiContext.setURLFactory(urlf);
        xwiki.prepareResources(this.xwikiContext);
        String username = "XWiki.XWikiGuest";
        XWikiUser user = this.xwikiContext.getWiki().checkAuth(this.xwikiContext);
        if (user != null) {
            username = user.getUser();
        }
        this.xwikiContext.setUser(username);
        if (this.xwikiContext.getDoc() == null) {
            this.xwikiContext.setDoc(new XWikiDocument("Fake", "Document"));
        }
        this.xwikiContext.put((Object)"ajax", (Object)Boolean.TRUE);
    }
}

