/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.utils;

import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;

public final class XWikiDavUtils {
    public static final String VIRTUAL_DIRECTORY_PREFIX = "_";
    public static final String VIRTUAL_DIRECTORY_POSTFIX = "_";
    public static final String XWIKI_ATTACHMENT_SIGNATURE = "/xwiki/bin/download/";
    public static final String XWIKI_WEBDAV_SIGNATURE = "/xwiki/webdav/spaces/";

    private XWikiDavUtils() {
    }

    public static int getSubViewNameLength(int totalDocumentCount) {
        if (totalDocumentCount < 200) {
            return 1;
        }
        if (totalDocumentCount < 5000) {
            return 2;
        }
        return 3;
    }

    public static String getDavURL(Document doc, Attachment attachment) {
        String docDownloadURL = doc.getExternalURL("download");
        String httpUrl = docDownloadURL.endsWith("/") ? docDownloadURL + attachment.getFilename() : docDownloadURL + "/" + attachment.getFilename();
        return XWikiDavUtils.getDavURL(httpUrl);
    }

    private static String getDavURL(String httpUrl) {
        String webDAVUrl = "";
        if (httpUrl.contains(XWIKI_ATTACHMENT_SIGNATURE)) {
            String[] parts = httpUrl.split(XWIKI_ATTACHMENT_SIGNATURE);
            String[] elements = parts[1].split("/");
            webDAVUrl = parts[0] + XWIKI_WEBDAV_SIGNATURE + elements[0] + "/" + elements[1] + "/" + elements[2];
        }
        return webDAVUrl;
    }

    public static interface ResourceHint {
        public static final String ROOT = "root";
        public static final String PAGES = "pages-baseview";
        public static final String ATTACHMENTS = "attachments-baseview";
        public static final String HOME = "home-baseview";
        public static final String ORPHANS = "orphans-baseview";
        public static final String WHATSNEW = "whatsnew-baseview";
    }
}

