/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav;

import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.utils.XWikiDavContext;
import com.xpn.xwiki.plugin.webdav.utils.XWikiDavResourceFactory;
import com.xpn.xwiki.plugin.webdav.utils.XWikiDavSessionProvider;
import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavMethods;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavRequestImpl;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.WebdavResponseImpl;
import org.apache.jackrabbit.webdav.server.AbstractWebdavServlet;
import org.apache.jackrabbit.webdav.simple.LocatorFactoryImplEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.container.Container;
import org.xwiki.context.Execution;

public class XWikiDavServlet
extends AbstractWebdavServlet {
    private static final long serialVersionUID = 7255582612577585483L;
    private static final Logger logger = LoggerFactory.getLogger(XWikiDavServlet.class);
    public static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    private transient DavLocatorFactory locatorFactory;
    private transient DavResourceFactory resourceFactory;
    private transient DavSessionProvider sessionProvider;

    public void init() throws ServletException {
        super.init();
        this.setLocatorFactory((DavLocatorFactory)new LocatorFactoryImplEx(""));
        this.setResourceFactory(new XWikiDavResourceFactory(this.getServletContext()));
        this.setDavSessionProvider(new XWikiDavSessionProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        XWikiDavResource resource;
        int methodCode;
        WebdavResponseImpl webdavResponse;
        WebdavRequestImpl webdavRequest;
        XWikiDavContext context;
        block12: {
            block11: {
                block10: {
                    context = null;
                    webdavRequest = new WebdavRequestImpl(request, this.getLocatorFactory());
                    webdavResponse = new WebdavResponseImpl(response, false);
                    methodCode = DavMethods.getMethodCode((String)request.getMethod());
                    if (this.getDavSessionProvider().attachSession((WebdavRequest)webdavRequest)) break block10;
                    this.cleaUp((WebdavRequest)webdavRequest, context);
                    return;
                }
                resource = (XWikiDavResource)this.getResourceFactory().createResource(webdavRequest.getRequestLocator(), (DavServletRequest)webdavRequest, (DavServletResponse)webdavResponse);
                context = resource.getContext();
                if (!"XWiki.XWikiGuest".equals(context.getUser())) break block11;
                webdavResponse.setStatus(401);
                webdavResponse.setHeader(WWW_AUTHENTICATE_HEADER, this.getAuthenticateHeaderValue());
                this.cleaUp((WebdavRequest)webdavRequest, context);
                return;
            }
            if (this.isPreconditionValid((WebdavRequest)webdavRequest, resource)) break block12;
            webdavResponse.sendError(412);
            this.cleaUp((WebdavRequest)webdavRequest, context);
            return;
        }
        try {
            if (!this.execute((WebdavRequest)webdavRequest, (WebdavResponse)webdavResponse, methodCode, resource)) {
                super.service(request, response);
            }
            this.cleaUp((WebdavRequest)webdavRequest, context);
        }
        catch (DavException e) {
            try {
                if (e.getErrorCode() == 401) {
                    webdavResponse.setHeader(WWW_AUTHENTICATE_HEADER, this.getAuthenticateHeaderValue());
                    webdavResponse.sendError(e.getErrorCode(), e.getStatusPhrase());
                } else {
                    logger.error("WebDAV Exception Occurred : ", (Throwable)e);
                    webdavResponse.sendError(e);
                }
                this.cleaUp((WebdavRequest)webdavRequest, context);
            }
            catch (Throwable throwable) {
                this.cleaUp((WebdavRequest)webdavRequest, context);
                throw throwable;
            }
        }
    }

    protected boolean execute(WebdavRequest request, WebdavResponse response, int method, DavResource resource) throws ServletException, IOException, DavException {
        logger.debug(String.format("Resource: [%s] Method: [%s]", resource.getDisplayName(), request.getMethod()));
        return super.execute(request, response, method, resource);
    }

    protected boolean isPreconditionValid(WebdavRequest request, DavResource resource) {
        return !resource.exists() || request.matchesIfHeader(resource);
    }

    public String getAuthenticateHeaderValue() {
        return "Basic realm=\"XWiki Webdav Server\"";
    }

    public DavLocatorFactory getLocatorFactory() {
        return this.locatorFactory;
    }

    public void setLocatorFactory(DavLocatorFactory locatorFactory) {
        this.locatorFactory = locatorFactory;
    }

    public DavResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public void setResourceFactory(DavResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    public synchronized DavSessionProvider getDavSessionProvider() {
        return this.sessionProvider;
    }

    public synchronized void setDavSessionProvider(DavSessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }

    public void cleaUp(WebdavRequest request, XWikiDavContext context) {
        Container container = (Container)Utils.getComponent(Container.class);
        Execution execution = (Execution)Utils.getComponent(Execution.class);
        container.removeRequest();
        container.removeResponse();
        container.removeSession();
        execution.removeContext();
        this.getDavSessionProvider().releaseSession(request);
        if (context != null) {
            context.cleanUp();
        }
    }
}

