/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.views;

import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavPage;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavView;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhatsnewView
extends AbstractDavView {
    private static final Logger logger = LoggerFactory.getLogger(WhatsnewView.class);

    public XWikiDavResource decode(String[] tokens, int next) throws DavException {
        boolean last;
        String nextToken = tokens[next];
        boolean bl = last = next == tokens.length - 1;
        if (this.isTempResource(nextToken)) {
            return super.decode(tokens, next);
        }
        if (!(!this.getContext().exists(nextToken) || last && this.getContext().isCreateOrMoveRequest())) {
            DavPage page = new DavPage();
            page.init(this, nextToken, "/" + nextToken);
            return last ? page : page.decode(tokens, next + 1);
        }
        throw new DavException(400);
    }

    public DavResourceIterator getMembers() {
        ArrayList<XWikiDavResource> children = new ArrayList<XWikiDavResource>();
        String sql = "where 1=1 order by doc.date desc";
        try {
            List<String> docNames = this.getContext().searchDocumentsNames(sql, 20, 0);
            for (String docName : docNames) {
                if (!this.getContext().hasAccess("view", docName)) continue;
                DavPage page = new DavPage();
                page.init(this, docName, "/" + docName);
                children.add(page);
            }
        }
        catch (DavException e) {
            logger.error("Unexpected Error : ", (Throwable)e);
        }
        children.addAll(this.getVirtualMembers());
        return new DavResourceIteratorImpl(children);
    }
}

