/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.views.attachments;

import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavPage;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavView;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentsByFirstLettersSubView
extends AbstractDavView {
    private static final Logger logger = LoggerFactory.getLogger(AttachmentsByFirstLettersSubView.class);

    public void init(XWikiDavResource parent, String name, String relativePath) throws DavException {
        super.init(parent, name, relativePath);
        if (!(name.startsWith("_") && name.endsWith("_") && name.equals(name.toUpperCase()))) {
            throw new DavException(500);
        }
    }

    public XWikiDavResource decode(String[] tokens, int next) throws DavException {
        boolean last;
        String nextToken = tokens[next];
        String pageName = this.getCollection().getDisplayName() + "." + nextToken;
        boolean bl = last = next == tokens.length - 1;
        if (this.isTempResource(nextToken)) {
            return super.decode(tokens, next);
        }
        if (!(!this.getContext().exists(pageName) || last && this.getContext().isCreateOrMoveRequest())) {
            DavPage page = new DavPage();
            page.init(this, pageName, "/" + nextToken);
            return last ? page : page.decode(tokens, next + 1);
        }
        throw new DavException(400);
    }

    public DavResourceIterator getMembers() {
        ArrayList<XWikiDavResource> children = new ArrayList<XWikiDavResource>();
        String spaceName = this.getCollection().getDisplayName();
        String filter = this.getDisplayName().substring("_".length(), this.getDisplayName().length() - "_".length());
        try {
            String sql = ", XWikiAttachment as attach where doc.id = attach.docId and doc.web = '" + spaceName + "'";
            List<String> docNames = this.getContext().searchDocumentsNames(sql);
            for (String docName : docNames) {
                int dot;
                String pageName;
                if (!this.getContext().hasAccess("view", docName) || !(pageName = docName.substring((dot = docName.lastIndexOf(46)) + 1)).toUpperCase().startsWith(filter)) continue;
                DavPage page = new DavPage();
                page.init(this, docName, "/" + pageName);
                children.add(page);
            }
        }
        catch (DavException e) {
            logger.error("Unexpected Error : ", (Throwable)e);
        }
        children.addAll(this.getVirtualMembers());
        return new DavResourceIteratorImpl(children);
    }
}

