/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.Panel;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.LayoutConstants;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.LayoutHelper;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.MultiLineLabel;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.n3.nanoxml.XMLElement;

public class IzPanel
extends JPanel
implements AbstractUIHandler,
LayoutConstants {
    private static final long serialVersionUID = 3256442495255786038L;
    protected LayoutHelper layoutHelper;
    protected Component initialFocus = null;
    protected InstallData idata;
    protected InstallerFrame parent;
    protected String myFullClassname;
    protected String myClassname;
    protected String myPrefix;
    protected String headline;
    protected JLabel headLineLabel;
    protected boolean hidden;
    public static final String HEADLINE = "headline";
    public static final int X_ORIGIN = 0;
    public static final int Y_ORIGIN = 0;
    public static final String D = ".";
    public static final String d = ".";
    public static final int COLS_1 = 1;
    public static final int ROWS_1 = 1;
    public Panel metadata;

    public IzPanel(InstallerFrame parent, InstallData idata) {
        this(parent, idata, (LayoutManager2)null);
    }

    public IzPanel(InstallerFrame parent, InstallData idata, LayoutManager2 lm) {
        this.init(parent, idata);
        if (lm != null) {
            this.getLayoutHelper().startLayout(lm);
        }
    }

    public IzPanel(InstallerFrame parent, InstallData idata, String iconName) {
        this(parent, idata, iconName, -1);
    }

    public IzPanel(InstallerFrame parent, InstallData idata, String iconName, int instance) {
        this(parent, idata);
        this.buildHeadline(iconName, instance);
    }

    protected boolean buildHeadline(String imageIconName, int instanceNumber) {
        String headline;
        boolean result = false;
        if (this.parent.isHeading(this)) {
            return false;
        }
        String headlineSearchBaseKey = this.myClassname + "." + HEADLINE;
        if (instanceNumber > -1) {
            String instanceSearchKey = headlineSearchBaseKey + "." + Integer.toString(instanceNumber);
            String instanceHeadline = this.getString(instanceSearchKey);
            if (Debug.isLOG()) {
                System.out.println("found headline: " + instanceHeadline + "." + " for instance # " + instanceNumber);
            }
            headline = !instanceSearchKey.equals(instanceHeadline) ? instanceHeadline : this.getString(headlineSearchBaseKey);
        } else {
            headline = this.getString(headlineSearchBaseKey);
        }
        if (headline != null) {
            this.headLineLabel = imageIconName != null && !"".equals(imageIconName) ? new JLabel(headline, this.getImageIcon(imageIconName), 10) : new JLabel(headline);
            Font font = this.headLineLabel.getFont();
            float size = font.getSize();
            int style = 0;
            font = font.deriveFont(style, size * 1.5f);
            this.headLineLabel.setFont(font);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.headLineLabel.setName(HEADLINE);
            ((GridBagLayout)this.getLayout()).addLayoutComponent(this.headLineLabel, gbc);
            this.add(this.headLineLabel);
        }
        return result;
    }

    public String getString(String key) {
        return this.parent.langpack.getString(key);
    }

    public ImageIcon getImageIcon(String iconName) {
        return this.parent.icons.getImageIcon(iconName);
    }

    protected void initLayoutHelper() {
        this.layoutHelper = new LayoutHelper(this);
    }

    protected void getClassName() {
        this.myFullClassname = this.getClass().getName();
        this.myClassname = this.myFullClassname.substring(this.myFullClassname.lastIndexOf(".") + 1);
        this.myPrefix = this.myClassname + ".";
    }

    protected void init(InstallerFrame parent, InstallData idata) {
        this.getClassName();
        this.idata = idata;
        this.parent = parent;
        this.metadata = idata.currentPanel;
        idata.currentPanel = null;
        this.initLayoutHelper();
    }

    public boolean isValidated() {
        return true;
    }

    public void panelActivate() {
    }

    public void panelDeactivate() {
    }

    public void makeXMLData(XMLElement panelRoot) {
    }

    public int askQuestion(String title, String question, int choices) {
        return this.askQuestion(title, question, choices, -1);
    }

    public int askQuestion(String title, String question, int choices, int default_choice) {
        int jo_choices = 0;
        if (choices == 37) {
            jo_choices = 0;
        } else if (choices == 38) {
            jo_choices = 1;
        }
        int user_choice = JOptionPane.showConfirmDialog(this, question, title, jo_choices, 3);
        if (user_choice == 2) {
            return 45;
        }
        if (user_choice == 0) {
            return 47;
        }
        if (user_choice == -1) {
            return 49;
        }
        if (user_choice == 1) {
            return 49;
        }
        return default_choice;
    }

    public boolean emitNotificationFeedback(String message) {
        return JOptionPane.showConfirmDialog(this, message, this.idata.langpack.getString("installer.Message"), 2, 2) == 0;
    }

    public void emitNotification(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    public boolean emitWarning(String title, String message) {
        return JOptionPane.showConfirmDialog(this, message, title, 2, 2) == 0;
    }

    public void emitError(String title, String message) {
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    public Component getInitialFocus() {
        return this.initialFocus;
    }

    public void setInitialFocus(Component component) {
        this.initialFocus = component;
    }

    public String getI18nStringForClass(String subkey) {
        String retval = null;
        Class<?> clazz = this.getClass();
        while (retval == null && !clazz.getName().endsWith(".IzPanel")) {
            retval = this.getI18nStringForClass(clazz.getName(), subkey, null);
            clazz = clazz.getSuperclass();
        }
        return retval;
    }

    public String getI18nStringForClass(String subkey, String alternateClass) {
        return this.getI18nStringForClass(this.getClass().getName(), subkey, alternateClass);
    }

    private String getI18nStringForClass(String curClassName, String subkey, String alternateClass) {
        int nameStart = curClassName.lastIndexOf(46) + 1;
        curClassName = curClassName.substring(nameStart, curClassName.length());
        StringBuffer buf = new StringBuffer();
        buf.append(curClassName).append(".").append(subkey);
        String fullkey = buf.toString();
        String panelid = null;
        if (this.getMetadata() != null) {
            panelid = this.getMetadata().getPanelid();
        }
        String retval = null;
        if (panelid != null) {
            buf.append(".");
            buf.append(panelid);
            retval = this.parent.langpack.getString(buf.toString());
        }
        if (retval == null || retval.startsWith(fullkey)) {
            retval = this.parent.langpack.getString(fullkey);
        }
        if (retval == null || retval.startsWith(fullkey)) {
            if (alternateClass == null) {
                return null;
            }
            buf.delete(0, buf.length());
            buf.append(alternateClass).append(".").append(subkey);
            retval = this.parent.langpack.getString(buf.toString());
        }
        if (retval != null && retval.indexOf(36) > -1) {
            VariableSubstitutor substitutor = new VariableSubstitutor(this.idata.getVariables());
            retval = substitutor.substitute(retval, null);
        }
        return retval;
    }

    public InstallerFrame getInstallerFrame() {
        return this.parent;
    }

    public JLabel createLabel(String subkey, String alternateClass, String iconId, int pos) {
        ImageIcon ii = iconId != null ? this.parent.icons.getImageIcon(iconId) : null;
        String msg = this.getI18nStringForClass(subkey, alternateClass);
        JLabel label = LabelFactory.create(msg, ii, pos);
        if (label != null) {
            label.setFont(this.getControlTextFont());
        }
        return label;
    }

    public JLabel createLabel(String subkey, String alternateClass, String iconId, int pos, boolean isFullLine) {
        ImageIcon ii = iconId != null ? this.parent.icons.getImageIcon(iconId) : null;
        String msg = this.getI18nStringForClass(subkey, alternateClass);
        JLabel label = LabelFactory.create(msg, ii, pos, isFullLine);
        if (label != null) {
            label.setFont(this.getControlTextFont());
        }
        return label;
    }

    public JLabel createLabel(String textId, String iconId, int pos) {
        return this.createLabel(textId, iconId, pos, false);
    }

    public JLabel createLabel(String textId, String iconId, int pos, boolean isFullLine) {
        ImageIcon ii = iconId != null ? this.parent.icons.getImageIcon(iconId) : null;
        JLabel label = LabelFactory.create(this.parent.langpack.getString(textId), ii, pos, isFullLine);
        if (label != null) {
            label.setFont(this.getControlTextFont());
        }
        return label;
    }

    public MultiLineLabel createMultiLineLabelLang(String textId) {
        return this.createMultiLineLabel(this.parent.langpack.getString(textId));
    }

    public MultiLineLabel createMultiLineLabel(String text) {
        return this.createMultiLineLabel(text, null, 2);
    }

    public MultiLineLabel createMultiLineLabel(String text, String iconId, int pos) {
        MultiLineLabel mll = null;
        mll = new MultiLineLabel(text, 0, 0);
        if (mll != null) {
            mll.setFont(this.getControlTextFont());
        }
        return mll;
    }

    public Font getControlTextFont() {
        return IzPanel.getLAF() != null ? MetalLookAndFeel.getControlTextFont() : this.getFont();
    }

    protected static MetalLookAndFeel getLAF() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof MetalLookAndFeel) {
            return (MetalLookAndFeel)laf;
        }
        return null;
    }

    public GridBagConstraints getDefaultGridBagConstraints() {
        return (GridBagConstraints)this.layoutHelper.getDefaultConstraints();
    }

    public void setDefaultGridBagConstraints(GridBagConstraints constraints) {
        this.layoutHelper.setDefaultConstraints(constraints);
    }

    public void resetGridCounter() {
        this.layoutHelper.resetGridCounter();
    }

    public GridBagConstraints getNewGridBagConstraints(int gridx, int gridy) {
        return (GridBagConstraints)this.layoutHelper.getNewConstraints(gridx, gridy);
    }

    public GridBagConstraints getNewGridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight) {
        return (GridBagConstraints)this.layoutHelper.getNewConstraints(gridx, gridy, gridwidth, gridheight);
    }

    public GridBagConstraints getNextXGridBagConstraints() {
        return (GridBagConstraints)this.layoutHelper.getNextXConstraints();
    }

    public GridBagConstraints getNextYGridBagConstraints() {
        return (GridBagConstraints)this.layoutHelper.getNextYConstraints();
    }

    public GridBagConstraints getNextYGridBagConstraints(int gridwidth, int gridheight) {
        return (GridBagConstraints)this.layoutHelper.getNextYConstraints(gridwidth, gridheight);
    }

    public void startGridBagLayout() {
        this.layoutHelper.startLayout(new GridBagLayout());
    }

    public void completeGridBagLayout() {
        this.layoutHelper.completeLayout();
    }

    public String getSummaryBody() {
        return null;
    }

    public String getSummaryCaption() {
        String caption = this.parent.isHeading(this) && this.idata.guiPrefs.modifier.containsKey("useHeadingForSummary") && ((String)this.idata.guiPrefs.modifier.get("useHeadingForSummary")).equalsIgnoreCase("yes") ? this.getI18nStringForClass(HEADLINE, this.getClass().getName()) : this.getI18nStringForClass("summaryCaption", this.getClass().getName());
        return caption;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public LayoutHelper getLayoutHelper() {
        return this.layoutHelper;
    }

    public Panel getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Panel p) {
        this.metadata = p;
    }

    public static class Filler
    extends JComponent {
        private static final long serialVersionUID = 3258416144414095153L;
    }
}

