/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.framework;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;
import junit.framework.Test;
import org.xwiki.test.XWikiExecutor;
import org.xwiki.test.XWikiTestSetup;

public class XWikiClusterTestSetup
extends XWikiTestSetup {
    private static final String WEBINF_PATH = "/observation/remote/jgroups";

    public XWikiClusterTestSetup(Test test) {
        super(test, 2);
    }

    protected void setUp() throws Exception {
        this.initChannel(0, "tcp1");
        this.initChannel(1, "tcp2");
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initChannel(int index, String channelName) throws Exception {
        XWikiExecutor executor = this.getXWikiExecutor(index);
        Properties properties = executor.loadXWikiProperties();
        properties.setProperty("observation.remote.enabled", "true");
        properties.setProperty("observation.remote.channels", channelName);
        executor.saveXWikiProperties(properties);
        Properties log4JProperties = executor.loadLog4JProperties();
        log4JProperties.setProperty("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
        log4JProperties.setProperty("log4j.appender.stdout.Target", "System.out");
        log4JProperties.setProperty("log4j.appender.stdout.layout", "org.apache.log4j.PatternLayout");
        log4JProperties.setProperty("log4j.appender.stdout.layout.ConversionPattern", "%d [%X{url}] [%t] %-5p %-30.30c{2} %x - %m %n");
        log4JProperties.setProperty("log4j.rootLogger", "warn, stdout");
        log4JProperties.setProperty("log4j.logger.org.xwiki.observation.remote", "debug");
        log4JProperties.setProperty("log4j.logger.com.xpn.xwiki.internal", "debug");
        executor.saveLog4JProperties(log4JProperties);
        String filename = channelName + ".xml";
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + filename);
        try {
            int nb;
            FileOutputStream fos = new FileOutputStream(executor.getWebInfDirectory() + WEBINF_PATH + "/" + filename);
            byte[] buffer = new byte[1024];
            while ((nb = is.read(buffer)) > 0) {
                fos.write(buffer, 0, nb);
            }
        }
        finally {
            is.close();
        }
    }
}

