/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.framework;

import com.xpn.xwiki.it.framework.LDAPRunner;
import com.xpn.xwiki.test.XWikiTestSetup;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import junit.framework.Test;

public class XWikiLDAPTestSetup
extends XWikiTestSetup {
    public static final String LDAP_USERUID_FIELD = "uid";
    public static final String SYSPROPNAME_LDAPPORT = "ldap_port";
    public static final String EXECUTION_DIRECTORY = System.getProperty("xwikiExecutionDirectory");
    public static final String XWIKI_CFG_FILE = EXECUTION_DIRECTORY + "/webapps/xwiki/WEB-INF/xwiki.cfg";
    public static final String HORATIOHORNBLOWER_DN = "cn=Horatio Hornblower,ou=people,o=sevenSeas";
    public static final String HORATIOHORNBLOWER_PWD = "pass";
    public static final String HORATIOHORNBLOWER_UID = "hhornblo";
    public static final String HMSLYDIA_DN = "cn=HMS Lydia,ou=crews,ou=groups,o=sevenSeas";
    public static final Set HMSLYDIA_MEMBERS = new HashSet();
    private LDAPRunner ldap = new LDAPRunner();
    private Properties initialXWikiConf;
    private Properties currentXWikiConf;

    public static int getLDAPPort() {
        return Integer.parseInt(System.getProperty(SYSPROPNAME_LDAPPORT));
    }

    public XWikiLDAPTestSetup(Test test) throws IOException {
        super(test);
        FileInputStream fis = new FileInputStream(XWIKI_CFG_FILE);
        this.initialXWikiConf = new Properties();
        this.initialXWikiConf.load(fis);
        this.currentXWikiConf = new Properties();
        this.currentXWikiConf.load(fis);
        fis.close();
        this.currentXWikiConf.setProperty("xwiki.authentication.ldap", "1");
        this.currentXWikiConf.setProperty("xwiki.authentication.ldap.authclass", "com.xpn.xwiki.user.impl.LDAP.LDAPAuthServiceImpl");
        this.currentXWikiConf.setProperty("xwiki.authentication.ldap.server", "localhost");
        this.currentXWikiConf.setProperty("xwiki.authentication.ldap.base_DN", "o=sevenSeas");
        this.currentXWikiConf.setProperty("xwiki.authentication.ldap.bind_DN", "cn={0},ou=people,o=sevenSeas");
        this.currentXWikiConf.setProperty("xwiki.authentication.ldap.UID_attr", LDAP_USERUID_FIELD);
        this.currentXWikiConf.setProperty("xwiki.authentication.ldap.fields_mapping", "name=uid,last_name=sn,first_name=givenname,fullname=description,email=mail,ldap_dn=dn");
        this.currentXWikiConf.setProperty("xwiki.authentication.ldap.group_mapping_1", "XWiki.XWikiAdminGroup=cn=HMS Lydia,ou=crews,ou=groups,o=sevenSeas");
    }

    protected void setUp() throws Exception {
        this.ldap.start();
        System.setProperty(SYSPROPNAME_LDAPPORT, "" + this.ldap.getPort());
        this.currentXWikiConf.setProperty("xwiki.authentication.ldap.port", "" + this.ldap.getPort());
        FileOutputStream fos = new FileOutputStream(XWIKI_CFG_FILE);
        this.currentXWikiConf.store(fos, null);
        fos.close();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        FileOutputStream fos = new FileOutputStream(XWIKI_CFG_FILE);
        this.initialXWikiConf.store(fos, null);
        fos.close();
        this.ldap.stop();
    }

    static {
        HMSLYDIA_MEMBERS.add(HORATIOHORNBLOWER_DN);
        HMSLYDIA_MEMBERS.add("cn=William Bush,ou=people,o=sevenSeas");
        HMSLYDIA_MEMBERS.add("cn=Thomas Quist,ou=people,o=sevenSeas");
        HMSLYDIA_MEMBERS.add("cn=Moultrie Crystal,ou=people,o=sevenSeas");
    }
}

