/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it;

import com.xpn.xwiki.it.selenium.framework.AbstractXWikiTestCase;
import com.xpn.xwiki.it.selenium.framework.ColibriSkinExecutor;
import com.xpn.xwiki.it.selenium.framework.XWikiTestSuite;
import junit.framework.Test;

public class LDAPAuthTest
extends AbstractXWikiTestCase {
    public static Test suite() {
        XWikiTestSuite suite = new XWikiTestSuite("Verify the LDAP login and logout features");
        suite.addTestSuite(LDAPAuthTest.class, ColibriSkinExecutor.class);
        return suite;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.open("Main", "WebHome");
        if (this.isAuthenticated()) {
            this.logout();
        }
        this.clickLogin();
    }

    public void testLogAsXWikiUser() {
        this.login("Admin", "admin", true);
    }

    public void testLogAsLDAPUser() {
        this.login("Horatio Hornblower", "pass", true);
        this.logout();
        this.clickLogin();
        this.setFieldValue("j_username", "Thomas Quist");
        this.setFieldValue("j_password", "pass");
        this.checkField("rememberme");
        this.submit();
        LDAPAuthTest.assertFalse((String)"Thomas Quist user has been authenticated", (boolean)this.isAuthenticated());
        this.loginAsAdmin();
        this.open("XWiki", "XWikiPreferences", "edit", "editor=object");
        this.setFieldValue("XWiki.XWikiPreferences_0_ldap_bind_DN", "cn=Horatio Hornblower,ou=people,o=sevenSeas");
        this.setFieldValue("XWiki.XWikiPreferences_0_ldap_bind_pass", "pass");
        this.setFieldValue("XWiki.XWikiPreferences_0_ldap_UID_attr", "uid");
        this.setFieldValue("XWiki.XWikiPreferences_0_ldap_fields_mapping", "name=uid,last_name=sn,first_name=givenname,fullname=description,email=mail");
        this.setFieldValue("XWiki.XWikiPreferences_0_ldap_group_mapping", "XWiki.XWikiAdminGroup=cn=HMS Lydia,ou=crews,ou=groups,o=sevenSeas");
        this.clickEditSaveAndView();
        this.login("wbush", "pass", true);
        this.login("wBush", "pass", true);
        this.open("XWiki", "XWikiAdminGroup");
        this.waitForBodyContains("XWiki.wbush");
        this.login("user.with.points", "pass", true);
    }
}

