/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.selenium;

import com.xpn.xwiki.it.selenium.framework.AbstractXWikiTestCase;
import com.xpn.xwiki.it.selenium.framework.XWikiTestSuite;
import junit.framework.Assert;
import junit.framework.Test;

public class WikiEditorTest
extends AbstractXWikiTestCase {
    static /* synthetic */ Class class$com$xpn$xwiki$it$selenium$WikiEditorTest;
    static /* synthetic */ Class class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor;

    public static Test suite() {
        XWikiTestSuite suite = new XWikiTestSuite("Tests the wiki editor");
        suite.addTestSuite(class$com$xpn$xwiki$it$selenium$WikiEditorTest == null ? (class$com$xpn$xwiki$it$selenium$WikiEditorTest = WikiEditorTest.class$("com.xpn.xwiki.it.selenium.WikiEditorTest")) : class$com$xpn$xwiki$it$selenium$WikiEditorTest, class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor == null ? (class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor = WikiEditorTest.class$("com.xpn.xwiki.it.selenium.framework.AlbatrossSkinExecutor")) : class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor);
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.loginAsAdmin();
    }

    public void testEmptyLineAndSpaceCharactersBeforeSectionTitleIsNotRemoved() {
        this.open("/xwiki/bin/edit/Test/WikiEdit?editor=wiki");
        this.setFieldValue("content", "\n  1.1 Section\n\ntext");
        this.clickEditSaveAndView();
        this.open("/xwiki/bin/edit/Test/WikiEdit?editor=wiki");
        Assert.assertEquals((String)"\n  1.1 Section\n\ntext", (String)this.getFieldValue("content"));
    }

    public void testBoldButton() {
        this.open("/xwiki/bin/edit/Test/WikiBoldButton?editor=wiki");
        this.setFieldValue("content", "Here follows a bold text: ");
        this.clickWikiBoldButton();
        Assert.assertEquals((String)"Failed to append bold marker", (String)"Here follows a bold text: *Text in Bold*", (String)this.getFieldValue("content"));
        this.setFieldValue("content", "Here follows a bold text: \nAnd some content after...");
        this.getSelenium().setCursorPosition("id=content", "26");
        this.clickWikiBoldButton();
        Assert.assertEquals((String)"Failed to insert bold marker", (String)"Here follows a bold text: *Text in Bold*\nAnd some content after...", (String)this.getFieldValue("content"));
    }

    public void testItalicsButton() {
        this.open("/xwiki/bin/edit/Test/WikiItalicsButton?editor=wiki");
        this.setFieldValue("content", "Here follows an italics text: ");
        this.clickWikiItalicsButton();
        Assert.assertEquals((String)"Failed to append italics marker", (String)"Here follows an italics text: ~~Text in Italics~~", (String)this.getFieldValue("content"));
        this.setFieldValue("content", "Here follows an italics text: \nAnd some content after...");
        this.getSelenium().setCursorPosition("id=content", "30");
        this.clickWikiItalicsButton();
        Assert.assertEquals((String)"Failed to insert italics marker", (String)"Here follows an italics text: ~~Text in Italics~~\nAnd some content after...", (String)this.getFieldValue("content"));
    }

    public void testUnderlineButton() {
        this.open("/xwiki/bin/edit/Test/WikiUnderlineButton?editor=wiki");
        this.setFieldValue("content", "Here follows an underlined text: ");
        this.clickWikiUnderlineButton();
        Assert.assertEquals((String)"Failed to append underline marker", (String)"Here follows an underlined text: __Text in Underline__", (String)this.getFieldValue("content"));
        this.setFieldValue("content", "Here follows an underlined text: \nAnd some content after...");
        this.getSelenium().setCursorPosition("id=content", "33");
        this.clickWikiUnderlineButton();
        Assert.assertEquals((String)"Failed to insert underline marker", (String)"Here follows an underlined text: __Text in Underline__\nAnd some content after...", (String)this.getFieldValue("content"));
    }

    public void testLinkButton() {
        this.open("/xwiki/bin/edit/Test/WikiLinkButton?editor=wiki");
        this.setFieldValue("content", "Here follows a link: ");
        this.clickWikiLinkButton();
        Assert.assertEquals((String)"Failed to append link marker", (String)"Here follows a link: [Link Example]", (String)this.getFieldValue("content"));
        this.setFieldValue("content", "Here follows a link: \nAnd some content after...");
        this.getSelenium().setCursorPosition("id=content", "21");
        this.clickWikiLinkButton();
        Assert.assertEquals((String)"Failed to insert link marker", (String)"Here follows a link: [Link Example]\nAnd some content after...", (String)this.getFieldValue("content"));
    }

    public void testHRButton() {
        this.open("/xwiki/bin/edit/Test/WikiHRButton?editor=wiki");
        this.setFieldValue("content", "Here follows a ruler: ");
        this.clickWikiHRButton();
        Assert.assertEquals((String)"Failed to append ruler marker", (String)"Here follows a ruler: \n----\n", (String)this.getFieldValue("content"));
        this.setFieldValue("content", "Here follows a ruler: \nAnd some content after...");
        this.getSelenium().setCursorPosition("id=content", "22");
        this.clickWikiHRButton();
        Assert.assertEquals((String)"Failed to insert ruler marker", (String)"Here follows a ruler: \n----\n\nAnd some content after...", (String)this.getFieldValue("content"));
    }

    public void testImageButton() {
        this.open("/xwiki/bin/edit/Test/WikiImageButton?editor=wiki");
        this.setFieldValue("content", "Here follows an image: ");
        this.clickWikiImageButton();
        Assert.assertEquals((String)"Failed to append image marker", (String)"Here follows an image: {image:example.jpg}", (String)this.getFieldValue("content"));
        this.setFieldValue("content", "Here follows an image: \nAnd some content after...");
        this.getSelenium().setCursorPosition("id=content", "23");
        this.clickWikiImageButton();
        Assert.assertEquals((String)"Failed to insert image marker", (String)"Here follows an image: {image:example.jpg}\nAnd some content after...", (String)this.getFieldValue("content"));
    }

    public void testSignatureButton() {
        this.open("/xwiki/bin/edit/Test/WikiSignatureButton?editor=wiki");
        this.setFieldValue("content", "Here follows a signature: ");
        this.clickWikiSignatureButton();
        Assert.assertEquals((String)"Failed to append signature marker", (String)"Here follows a signature: #sign(\"XWiki.Admin\")sigtext", (String)this.getFieldValue("content"));
        this.setFieldValue("content", "Here follows a signature: \nAnd some content after...");
        this.getSelenium().setCursorPosition("id=content", "26");
        this.clickWikiSignatureButton();
        Assert.assertEquals((String)"Failed to insert signature marker", (String)"Here follows a signature: #sign(\"XWiki.Admin\")sigtext\nAnd some content after...", (String)this.getFieldValue("content"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

