/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.selenium;

import com.xpn.xwiki.it.selenium.framework.AbstractXWikiTestCase;
import com.xpn.xwiki.it.selenium.framework.XWikiTestSuite;
import junit.framework.Test;

public class WysiwygEditorTest
extends AbstractXWikiTestCase {
    static /* synthetic */ Class class$com$xpn$xwiki$it$selenium$WysiwygEditorTest;
    static /* synthetic */ Class class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor;

    public static Test suite() {
        XWikiTestSuite suite = new XWikiTestSuite("Tests the wiki editor");
        suite.addTestSuite(class$com$xpn$xwiki$it$selenium$WysiwygEditorTest == null ? (class$com$xpn$xwiki$it$selenium$WysiwygEditorTest = WysiwygEditorTest.class$("com.xpn.xwiki.it.selenium.WysiwygEditorTest")) : class$com$xpn$xwiki$it$selenium$WysiwygEditorTest, class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor == null ? (class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor = WysiwygEditorTest.class$("com.xpn.xwiki.it.selenium.framework.AlbatrossSkinExecutor")) : class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor);
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.loginAsAdmin();
        this.editInWysiwyg("Test", "TestWysiwyg");
        this.clearWysiwygContent();
    }

    public void testSimpleList() {
        this.typeInWysiwyg("item1");
        this.clickWysiwygUnorderedListButton();
        this.typeEnterInWysiwyg();
        this.typeInWysiwyg("item2");
        this.typeEnterInWysiwyg();
        this.typeInWysiwyg("item3");
        this.assertWikiTextGeneratedByWysiwyg("* item1\n* item2\n* item3");
    }

    public void testIndentation() {
        this.typeInWysiwyg("Text");
        this.typeEnterInWysiwyg();
        this.clickWysiwygIndentButton();
        this.typeInWysiwyg("some indented text");
        this.assertWikiTextGeneratedByWysiwyg("Text\n<blockquote>\nsome indented text\n</blockquote>");
    }

    public void testLineFeed() {
        this.typeInWysiwyg("Text");
        this.typeEnterInWysiwyg();
        this.typeInWysiwyg("Text");
        this.assertWikiTextGeneratedByWysiwyg("Text\n\nText");
    }

    public void testLineFeedWhenUsingShiftEnter() {
        this.typeInWysiwyg("Text");
        this.typeShiftEnterInWysiwyg();
        this.typeInWysiwyg("Text");
        this.assertWikiTextGeneratedByWysiwyg("Text\\\\\nText");
    }

    public void testLineFeedBeforeAndAfterLists() {
        this.typeInWysiwyg("Text");
        this.typeEnterInWysiwyg();
        this.typeInWysiwyg("item");
        this.clickWysiwygUnorderedListButton();
        this.typeEnterInWysiwyg();
        this.clickWysiwygUnorderedListButton();
        this.typeInWysiwyg("Text");
        this.assertWikiTextGeneratedByWysiwyg("Text\n\n* item\n\nText");
    }

    public void testEscapedHtmlElement() {
        this.typeInWysiwyg("http://\\<yourserver\\>:8080/something");
        this.assertWikiTextGeneratedByWysiwyg("http://\\<yourserver\\>:8080/something");
    }

    public void testHtmlElementIsRendered() {
        this.typeInWysiwyg("<table><tr><td>hello</td></tr></table>");
        this.assertWikiTextGeneratedByWysiwyg("<table><tr><td>hello</td></tr></table>");
    }

    public void testNestedOrderedList() {
        this.clickWysiwygOrderedListButton();
        this.typeInWysiwyg("level 1");
        this.typeEnterInWysiwyg();
        this.clickWysiwygIndentButton();
        this.typeInWysiwyg("level 2");
        this.assertWikiTextGeneratedByWysiwyg("1. level 1\n11. level 2");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

