/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.selenium.framework;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import com.xpn.xwiki.it.selenium.framework.SkinExecutor;
import junit.framework.Assert;
import junit.framework.TestCase;

public class AbstractXWikiTestCase
extends TestCase
implements SkinExecutor {
    private SkinExecutor skinExecutor;
    private static final String PORT = System.getProperty("xwikiPort", "8080");
    private static final String BASE_URL = "http://localhost:" + PORT;
    private Selenium selenium;
    static /* synthetic */ Class class$com$xpn$xwiki$it$selenium$framework$XWikiTestSuite;

    public void setSkinExecutor(SkinExecutor skinExecutor) {
        this.skinExecutor = skinExecutor;
    }

    public SkinExecutor getSkinExecutor() {
        if (this.skinExecutor == null) {
            throw new RuntimeException("Skin executor hasn't been initialized. Make sure to wrap your test in a " + (class$com$xpn$xwiki$it$selenium$framework$XWikiTestSuite == null ? (class$com$xpn$xwiki$it$selenium$framework$XWikiTestSuite = AbstractXWikiTestCase.class$("com.xpn.xwiki.it.selenium.framework.XWikiTestSuite")) : class$com$xpn$xwiki$it$selenium$framework$XWikiTestSuite).getName() + " class and call " + " addTestSuite(Class testClass, SkinExecutor skinExecutor).");
        }
        return this.skinExecutor;
    }

    protected void setUp() throws Exception {
        super.setUp();
        String browser = System.getProperty("browser", "*firefox");
        this.selenium = new DefaultSelenium("localhost", 4444, browser, BASE_URL);
        this.selenium.start();
    }

    public void tearDown() throws Exception {
        this.getSelenium().stop();
    }

    public Selenium getSelenium() {
        return this.selenium;
    }

    public void open(String url) {
        this.getSelenium().open(url);
    }

    public String getTitle() {
        return this.getSelenium().getTitle();
    }

    public void assertPage(String space, String page) {
        Assert.assertEquals((String)("XWiki - " + space + " - " + page), (String)this.getTitle());
    }

    public boolean isElementPresent(String locator) {
        return this.getSelenium().isElementPresent(locator);
    }

    public boolean isLinkPresent(String text) {
        return this.isElementPresent("link=" + text);
    }

    public void clickLinkWithText(String text) {
        this.clickLinkWithText(text, true);
    }

    public void assertTextPresent(String text) {
        Assert.assertTrue((String)("[" + text + "] isn't present."), (boolean)this.getSelenium().isTextPresent(text));
    }

    public void assertElementPresent(String elementLocator) {
        Assert.assertTrue((String)("[" + elementLocator + "] isn't present."), (boolean)this.isElementPresent(elementLocator));
    }

    public void assertElementNotPresent(String elementLocator) {
        Assert.assertFalse((String)("[" + elementLocator + "] is present."), (boolean)this.isElementPresent(elementLocator));
    }

    public void waitPage() {
        this.waitPage(180000);
    }

    public void waitPage(int nbMillisecond) {
        this.getSelenium().waitForPageToLoad(String.valueOf(nbMillisecond));
    }

    public void clickLinkWithLocator(String locator) {
        this.clickLinkWithLocator(locator, true);
    }

    public void clickLinkWithLocator(String locator, boolean wait) {
        this.assertElementPresent(locator);
        this.getSelenium().click(locator);
        if (wait) {
            this.waitPage();
        }
    }

    public void clickLinkWithText(String text, boolean wait) {
        this.clickLinkWithLocator("link=" + text, wait);
    }

    public boolean isChecked(String locator) {
        return this.getSelenium().isChecked(locator);
    }

    public String getFieldValue(String fieldName) {
        return this.getSelenium().getEval("selenium.browserbot.getCurrentWindow().document.getElementById(\"" + fieldName + "\").value");
    }

    public void setFieldValue(String fieldName, String value) {
        this.getSelenium().type(fieldName, value);
    }

    public void checkField(String locator) {
        this.getSelenium().check(locator);
    }

    public void submit() {
        this.clickLinkWithXPath("//input[@type='submit']");
    }

    public void submit(String locator) {
        this.clickLinkWithLocator(locator);
    }

    public void submit(String locator, boolean wait) {
        this.clickLinkWithLocator(locator, wait);
    }

    public void clickLinkWithXPath(String xpath) {
        this.clickLinkWithXPath(xpath, true);
    }

    public void clickLinkWithXPath(String xpath, boolean wait) {
        this.clickLinkWithLocator("xpath=" + xpath, wait);
    }

    public void clickDeletePage() {
        this.getSkinExecutor().clickDeletePage();
    }

    public void clickEditPreview() {
        this.getSkinExecutor().clickEditPreview();
    }

    public void clickEditSaveAndContinue() {
        this.getSkinExecutor().clickEditSaveAndContinue();
    }

    public void clickEditCancelEdition() {
        this.getSkinExecutor().clickEditCancelEdition();
    }

    public void clickEditSaveAndView() {
        this.getSkinExecutor().clickEditSaveAndView();
    }

    public boolean isAuthenticated() {
        return this.getSkinExecutor().isAuthenticated();
    }

    public void logout() {
        this.getSkinExecutor().logout();
    }

    public void login(String username, String password, boolean rememberme) {
        this.getSkinExecutor().login(username, password, rememberme);
    }

    public void loginAsAdmin() {
        this.getSkinExecutor().loginAsAdmin();
    }

    public void clickLogin() {
        this.getSkinExecutor().clickLogin();
    }

    public void clickRegister() {
        this.getSkinExecutor().clickRegister();
    }

    public void editInWysiwyg(String space, String page) {
        this.getSkinExecutor().editInWysiwyg(space, page);
    }

    public void clearWysiwygContent() {
        this.getSkinExecutor().clearWysiwygContent();
    }

    public void typeInWysiwyg(String text) {
        this.getSkinExecutor().typeInWysiwyg(text);
    }

    public void typeInWiki(String text) {
        this.getSkinExecutor().typeInWiki(text);
    }

    public void typeEnterInWysiwyg() {
        this.getSkinExecutor().typeEnterInWysiwyg();
    }

    public void typeShiftEnterInWysiwyg() {
        this.getSkinExecutor().typeShiftEnterInWysiwyg();
    }

    public void clickWysiwygUnorderedListButton() {
        this.getSkinExecutor().clickWysiwygUnorderedListButton();
    }

    public void clickWysiwygOrderedListButton() {
        this.getSkinExecutor().clickWysiwygOrderedListButton();
    }

    public void clickWysiwygIndentButton() {
        this.getSkinExecutor().clickWysiwygIndentButton();
    }

    public void clickWysiwygOutdentButton() {
        this.getSkinExecutor().clickWysiwygOutdentButton();
    }

    public void clickWikiBoldButton() {
        this.getSkinExecutor().clickWikiBoldButton();
    }

    public void clickWikiItalicsButton() {
        this.getSkinExecutor().clickWikiItalicsButton();
    }

    public void clickWikiUnderlineButton() {
        this.getSkinExecutor().clickWikiUnderlineButton();
    }

    public void clickWikiLinkButton() {
        this.getSkinExecutor().clickWikiLinkButton();
    }

    public void clickWikiHRButton() {
        this.getSkinExecutor().clickWikiHRButton();
    }

    public void clickWikiImageButton() {
        this.getSkinExecutor().clickWikiImageButton();
    }

    public void clickWikiSignatureButton() {
        this.getSkinExecutor().clickWikiSignatureButton();
    }

    public void assertWikiTextGeneratedByWysiwyg(String text) {
        this.getSkinExecutor().assertWikiTextGeneratedByWysiwyg(text);
    }

    public void assertHTMLGeneratedByWysiwyg(String xpath) throws Exception {
        this.getSkinExecutor().assertHTMLGeneratedByWysiwyg(xpath);
    }

    public void assertGeneratedHTML(String xpath) throws Exception {
        this.getSkinExecutor().assertGeneratedHTML(xpath);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

