/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.framework.elements;

import java.util.HashMap;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.it.ui.framework.elements.BasePage;
import org.xwiki.it.ui.framework.elements.FormElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterPage
extends BasePage {
    @FindBy(id="register")
    private WebElement registerFormElement;
    @FindBy(xpath="//form[@id='register']/div/span/input[@type='submit']")
    private WebElement submitButton;
    private FormElement form;

    public void gotoPage() {
        this.getUtil().gotoPage("XWiki", "Register", "register");
    }

    public void fillInJohnSmithValues() {
        this.fillRegisterForm("John", "Smith", "JohnSmith", "WeakPassword", "WeakPassword", "johnsmith@xwiki.org");
    }

    public void fillRegisterForm(String firstName, String lastName, String username, String password, String confirmPassword, String email) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (firstName != null) {
            map.put("register_first_name", firstName);
        }
        if (lastName != null) {
            map.put("register_last_name", lastName);
        }
        if (username != null) {
            map.put("xwikiname", username);
        }
        if (password != null) {
            map.put("register_password", password);
        }
        if (confirmPassword != null) {
            map.put("register2_password", confirmPassword);
        }
        if (email != null) {
            map.put("register_email", email);
        }
        this.getForm().fillFieldsByName(map);
    }

    private FormElement getForm() {
        if (this.form == null) {
            this.form = new FormElement(this.registerFormElement);
        }
        return this.form;
    }

    public void clickRegister() {
        this.submitButton.click();
    }

    public List<WebElement> getValidationFailureMessages() {
        return this.getDriver().findElements(By.xpath((String)"//dd/span[@class='LV_validation_message LV_invalid']"));
    }

    public boolean validationFailureMessagesInclude(String message) {
        for (WebElement messageElement : this.getValidationFailureMessages()) {
            if (!messageElement.getText().equals(message)) continue;
            return true;
        }
        return false;
    }

    public boolean liveValidationEnabled() {
        return !this.getDriver().findElements(By.xpath((String)"//div[@id='mainContentArea']/script")).isEmpty();
    }

    public void triggerLiveValidation() {
        this.registerFormElement.findElement(By.name((String)"register2_password")).click();
        this.registerFormElement.findElement(By.name((String)"register_password")).click();
        this.registerFormElement.findElement(By.name((String)"xwikiname")).click();
        this.registerFormElement.findElement(By.name((String)"register_first_name")).click();
    }
}

