/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.framework.elements;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.xwiki.it.ui.administration.elements.AdministrationPage;
import org.xwiki.it.ui.framework.elements.BasePage;
import org.xwiki.it.ui.framework.elements.CommentsPane;
import org.xwiki.it.ui.framework.elements.CreatePagePage;
import org.xwiki.it.ui.framework.elements.CreateSpacePage;
import org.xwiki.it.ui.framework.elements.HistoryPane;
import org.xwiki.it.ui.framework.elements.LoginPage;
import org.xwiki.it.ui.framework.elements.RegisterPage;
import org.xwiki.it.ui.xe.elements.HomePage;

public class ViewPage
extends BasePage {
    @FindBys(value={@FindBy(id="tmRegister"), @FindBy(tagName="a")})
    private WebElement registerLink;
    @FindBys(value={@FindBy(id="tmLogin"), @FindBy(tagName="a")})
    private WebElement loginLink;
    @FindBys(value={@FindBy(id="tmLogout"), @FindBy(tagName="a")})
    private WebElement logoutLink;
    @FindBys(value={@FindBy(id="tmUser"), @FindBy(tagName="a")})
    private WebElement userLink;
    @FindBy(id="tmCreatePage")
    private WebElement createPageMenuLink;
    @FindBy(id="tmCreateSpace")
    private WebElement createSpaceMenuLink;
    @FindBy(id="tmAdminWiki")
    private WebElement administerWikiMenuLink;
    @FindBy(id="xwikicontent")
    private WebElement content;

    public void loginAsAdmin() {
        if (!this.isAuthenticated()) {
            if (!this.hasLoginLink()) {
                String thisPage = this.getPageURL();
                HomePage homePage = new HomePage();
                homePage.gotoPage();
                this.clickLogin().loginAsAdmin();
                this.getDriver().get(thisPage);
            } else {
                this.clickLogin().loginAsAdmin();
            }
        }
    }

    public boolean hasLoginLink() {
        return !this.getDriver().findElements(By.id((String)"tmLogin")).isEmpty();
    }

    public LoginPage clickLogin() {
        this.loginLink.click();
        return new LoginPage();
    }

    public String getCurrentUser() {
        return this.userLink.getText();
    }

    public void clickLogout() {
        this.logoutLink.click();
    }

    public RegisterPage clickRegister() {
        this.registerLink.click();
        return new RegisterPage();
    }

    public CreatePagePage createPage() {
        this.hoverOverMenu("tmSpace");
        this.createPageMenuLink.click();
        return new CreatePagePage();
    }

    public CreateSpacePage createSpace() {
        this.hoverOverMenu("tmWiki");
        this.createSpaceMenuLink.click();
        return new CreateSpacePage();
    }

    public AdministrationPage administerWiki() {
        this.hoverOverMenu("tmWiki");
        this.administerWikiMenuLink.click();
        return new AdministrationPage();
    }

    public void deleteCurrentPage() {
        this.getDriver().findElement(By.partialLinkText((String)"More actions")).click();
        this.getDriver().findElement(By.linkText((String)"Delete")).click();
        this.getDriver().findElement(By.xpath((String)"//input[@value='yes']")).click();
        this.makeConfirmDialogSilent();
        this.getDriver().findElement(By.partialLinkText((String)"Delete")).click();
    }

    public CommentsPane openCommentsDocExtraPane() {
        this.getDriver().findElement(By.id((String)"Commentslink")).click();
        this.waitUntilElementIsVisible(By.id((String)"commentscontent"));
        return new CommentsPane();
    }

    public HistoryPane openHistoryDocExtraPane() {
        this.getDriver().findElement(By.id((String)"Historylink")).click();
        this.waitUntilElementIsVisible(By.id((String)"historycontent"));
        return new HistoryPane();
    }

    public boolean exists() {
        List messages = this.getDriver().findElements(By.className((String)"xwikimessage"));
        for (WebElement message : messages) {
            if (!message.getText().equals("The requested document could not be found.") && !message.getText().equals("The document has been deleted.")) continue;
            return false;
        }
        return true;
    }

    public String getContent() {
        return this.content.getText();
    }
}

