/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.framework;

import com.google.common.base.Function;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.TimeoutException;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.xwiki.it.ui.framework.PersistentTestContext;
import org.xwiki.it.ui.framework.elements.ViewPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtils {
    private static PersistentTestContext context;
    private int timeout = 10;
    private final String baseURL = "http://localhost:8080/xwiki/bin/";

    public static void setContext(PersistentTestContext context) {
        TestUtils.context = context;
    }

    protected WebDriver getDriver() {
        return context.getDriver();
    }

    public Session getSession() {
        return new Session(this.getDriver().manage().getCookies());
    }

    public void setSession(Session session) {
        WebDriver.Options options = this.getDriver().manage();
        options.deleteAllCookies();
        if (session != null) {
            for (Cookie cookie : session.getCookies()) {
                options.addCookie(cookie);
            }
        }
    }

    public String getURLToLogout() {
        return this.getURL("XWiki", "XWikiLogin", "logout");
    }

    public String getURLToLoginAsAdmin() {
        return this.getURLToLoginAs("Admin", "admin");
    }

    public String getURLToLoginAs(String username, String password) {
        return this.getURLToLoginAndGotoPage(username, password, null);
    }

    public String getURLToLoginAsAdminAndGotoPage(String pageURL) {
        return this.getURLToLoginAndGotoPage("Admin", "admin", pageURL);
    }

    public String getURLToLoginAndGotoPage(final String username, final String password, final String pageURL) {
        HashMap<String, String> parameters = new HashMap<String, String>(){
            {
                this.put("j_username", username);
                this.put("j_password", password);
                if (pageURL != null && pageURL.length() > 0) {
                    this.put("xredirect", pageURL);
                }
            }
        };
        return this.getURL("XWiki", "XWikiLogin", "loginsubmit", (Map<String, String>)parameters);
    }

    public void assertOnPage(String pageURL) {
        final String pageURI = pageURL.replaceAll("\\?.*", "");
        try {
            WebDriverWait wait = new WebDriverWait(this.getDriver(), (long)this.getTimeout());
            wait.until((Function)new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver driver) {
                    return TestUtils.this.getDriver().getCurrentUrl().contains(pageURI);
                }
            });
        }
        catch (TimeoutException e) {
            Assert.fail((String)("Failed to go to the page: " + pageURL + "\nCurrent page is " + this.getDriver().getCurrentUrl()));
        }
    }

    public String getLoggedInUserName() {
        String loggedInUserName = null;
        List elements = this.getDriver().findElements(By.xpath((String)"//div[@id='tmUser']/span/a"));
        if (!elements.isEmpty()) {
            String href = ((WebElement)elements.get(0)).getAttribute("href");
            loggedInUserName = href.substring(href.lastIndexOf("/") + 1);
        }
        return loggedInUserName;
    }

    public void registerLoginAndGotoPage(final String username, final String password, final String pageURL) {
        String registerURL = this.getURL("XWiki", "Register", "register", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("register", "1");
                this.put("xwikiname", username);
                this.put("register_password", password);
                this.put("register2_password", password);
                this.put("register_email", "");
                this.put("xredirect", TestUtils.this.getURLToLoginAndGotoPage(username, password, pageURL));
            }
        });
        this.getDriver().get(registerURL);
    }

    public ViewPage gotoPage(String space, String page) {
        this.gotoPage(space, page, "view");
        return new ViewPage();
    }

    public void gotoPage(String space, String page, String action) {
        this.gotoPage(space, page, action, "");
    }

    public void gotoPage(String space, String page, String action, Map<String, String> queryParameters) {
        this.getDriver().get(this.getURL(space, page, action, queryParameters));
    }

    public void gotoPage(String space, String page, String action, String queryString) {
        String url = this.getURL(space, page, action, queryString);
        if (!this.getDriver().getCurrentUrl().equals(url)) {
            this.getDriver().get(url);
        }
    }

    public String getURLToDeletePage(String space, String page) {
        return this.getURL(space, page, "delete", "confirm=1");
    }

    public void deletePage(String space, String page) {
        this.getDriver().get(this.getURLToDeletePage(space, page));
    }

    public String getURL(String space, String page) {
        return this.getURL(space, page, "view");
    }

    public String getURL(String space, String page, String action) {
        return this.getURL(space, page, action, "");
    }

    public String getURL(String space, String page, String action, String queryString) {
        return this.baseURL + action + "/" + this.escapeURL(space) + "/" + this.escapeURL(page) + (queryString == null || queryString.length() < 1 ? "" : "?" + queryString);
    }

    public String getURL(String space, String page, String action, Map<String, String> queryParameters) {
        String queryString = "";
        for (String key : queryParameters.keySet()) {
            queryString = queryString + this.escapeURL(key) + "=" + this.escapeURL(queryParameters.get(key)) + "&";
        }
        return this.getURL(space, page, action, queryString);
    }

    public String escapeURL(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Session {
        private final Set<Cookie> cookies;

        private Session(final Set<Cookie> cookies) {
            this.cookies = Collections.unmodifiableSet(new HashSet<Cookie>(){
                {
                    this.addAll(cookies);
                }
            });
        }

        private Set<Cookie> getCookies() {
            return this.cookies;
        }
    }
}

