/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.framework.elements;

import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.it.ui.framework.elements.PreferencesPage;
import org.xwiki.it.ui.framework.elements.ViewPage;
import org.xwiki.it.ui.framework.elements.editor.ChangeAvatarPage;
import org.xwiki.it.ui.framework.elements.editor.ProfileEditPage;

public class ProfilePage
extends ViewPage {
    private final String targetUsername;
    @FindBy(xpath="//div[@class='userInfo']/div[@class='editProfileCategory']/a")
    private WebElement editProfile;
    @FindBy(className="given-name")
    private WebElement userFirstName;
    @FindBy(className="family-name")
    private WebElement userLastName;
    @FindBy(className="org")
    private WebElement userCompany;
    @FindBy(className="note")
    private WebElement userAbout;
    @FindBy(className="email")
    private WebElement userEmail;
    @FindBy(className="tel")
    private WebElement userPhone;
    @FindBy(className="adr")
    private WebElement userAddress;
    @FindBy(xpath="//dd[1]/span[@class='wikiexternallink']")
    private WebElement userBlog;
    @FindBy(xpath="//dd[2]/span[@class='wikiexternallink']")
    private WebElement userBlogFeed;
    @FindBy(xpath="//div[@id='avatar']//a")
    private WebElement userAvatar;
    @FindBy(xpath="//div[@id='avatar']//a/img")
    private WebElement userAvatarImage;
    @FindBy(xpath="//a[@href='?category=profile']")
    private WebElement profile;
    @FindBy(xpath="//a[@href='?category=preferences']")
    private WebElement preferences;

    public ProfilePage() {
        this("Admin");
    }

    public ProfilePage(String username) {
        this.targetUsername = username;
    }

    public ProfileEditPage editProfile() {
        this.editProfile.click();
        return new ProfileEditPage();
    }

    public void gotoPage() {
        this.getUtil().gotoPage("XWiki", this.targetUsername);
    }

    public boolean isOnProfilePage() {
        return this.getDriver().getCurrentUrl().equals(this.getUtil().getURL("XWiki", this.targetUsername));
    }

    public String getUserFirstName() {
        return this.userFirstName.getText();
    }

    public String getUserLastName() {
        return this.userLastName.getText();
    }

    public String getUserCompany() {
        return this.userCompany.getText();
    }

    public String getUserAbout() {
        return this.userAbout.getText();
    }

    public String getUserEmail() {
        return this.userEmail.getText();
    }

    public String getUserPhone() {
        return this.userPhone.getText();
    }

    public String getUserAddress() {
        return this.userAddress.getText();
    }

    public String getUserBlog() {
        return this.userBlog.getText();
    }

    public String getUserBlogFeed() {
        return this.userBlogFeed.getText();
    }

    public ChangeAvatarPage changeAvatarImage() {
        this.userAvatar.click();
        return new ChangeAvatarPage();
    }

    public String getAvatarImageName() {
        return StringUtils.substringBefore((String)StringUtils.substringAfterLast((String)this.userAvatarImage.getAttribute("src"), (String)"/"), (String)"?");
    }

    public PreferencesPage switchToPreferences() {
        this.preferences.click();
        return new PreferencesPage();
    }

    public ProfilePage switchToProfile() {
        this.profile.click();
        return new ProfilePage();
    }
}

