/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.selenium;

import com.xpn.xwiki.it.selenium.framework.AbstractWysiwygTestCase;
import com.xpn.xwiki.it.selenium.framework.AlbatrossSkinExecutor;
import com.xpn.xwiki.it.selenium.framework.XWikiTestSuite;
import junit.framework.Test;

public class ColorSupportTest
extends AbstractWysiwygTestCase {
    public static Test suite() {
        XWikiTestSuite suite = new XWikiTestSuite("Functional tests for color support inside the WYSIWYG editor.");
        suite.addTestSuite(ColorSupportTest.class, AlbatrossSkinExecutor.class);
        return suite;
    }

    public void testChangeTextColor() {
        this.typeText("abc");
        this.select("XWE.body.firstChild", 1, "XWE.body.firstChild", 2);
        this.clickForegroundColorButton();
        this.selectColor("rgb(255, 0, 0)");
        this.assertWiki("a(% style=\"color: rgb(255, 0, 0);\" %)b(%%)c");
        this.moveCaret("XWE.body.getElementsByTagName('span')[0].firstChild", 1);
        this.clickForegroundColorButton();
        this.assertSelectedColor("rgb(255, 0, 0)");
        this.hideColorPicker();
    }

    public void testChangeBackgroundColor() {
        this.typeText("abc");
        this.select("XWE.body.firstChild", 1, "XWE.body.firstChild", 2);
        this.clickBackgroundColorButton();
        this.selectColor("rgb(255, 0, 0)");
        this.assertWiki("a(% style=\"background-color: rgb(255, 0, 0);\" %)b(%%)c");
        this.moveCaret("XWE.body.getElementsByTagName('span')[0].firstChild", 1);
        this.clickBackgroundColorButton();
        this.assertSelectedColor("rgb(255, 0, 0)");
        this.hideColorPicker();
    }

    public void testChangeTextAndBackgroudColor() {
        this.setWikiContent("(% style=\"color: red; background-color:#777;\" %)\nfoo");
        this.selectNodeContents("XWE.body.firstChild");
        this.clickForegroundColorButton();
        this.selectColor("rgb(0, 255, 0)");
        this.clickBackgroundColorButton();
        this.selectColor("rgb(252, 229, 205)");
        this.assertWiki("(% style=\"color: rgb(0, 255, 0); background-color: rgb(252, 229, 205);\" %)\nfoo");
    }

    public void testRemoveBoldStyleFromAColoredText() {
        this.typeText("bar");
        this.selectAllContent();
        this.clickBoldButton();
        this.clickForegroundColorButton();
        this.selectColor("rgb(0, 0, 255)");
        this.clickBoldButton();
        this.assertWiki("(% style=\"color: rgb(0, 0, 255);\" %)bar");
    }

    public void testChangeTextColorAfterSelectingTextWithDifferentColors() {
        this.typeText("foo bar");
        this.select("XWE.body.firstChild", 0, "XWE.body.firstChild", 3);
        this.clickForegroundColorButton();
        this.selectColor("rgb(255, 0, 0)");
        this.select("XWE.body.childNodes[1]", 1, "XWE.body.childNodes[1]", 4);
        this.clickForegroundColorButton();
        this.selectColor("rgb(0, 0, 255)");
        this.selectAllContent();
        this.clickForegroundColorButton();
        this.selectColor("rgb(0, 255, 0)");
        this.assertWiki("(% style=\"color: rgb(0, 255, 0);\" %)foo bar");
    }

    protected void clickForegroundColorButton() {
        this.pushButton("//div[@title='Select text color']");
    }

    protected void clickBackgroundColorButton() {
        this.pushButton("//div[@title='Select background color']");
    }

    protected void selectColor(String rgbColor) {
        this.getSelenium().click("//div[@class = 'colorCell' and @style = 'background-color: " + rgbColor + ";']");
    }

    protected void assertSelectedColor(String rgbColor) {
        this.assertElementPresent("//div[@class = 'colorCell-selected' and @style = 'background-color: " + rgbColor + ";']");
    }

    protected void hideColorPicker() {
        this.pushButton(this.getDOMLocator("body"));
    }
}

