/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.selenium;

import com.xpn.xwiki.it.selenium.framework.AbstractWysiwygTestCase;
import com.xpn.xwiki.it.selenium.framework.AlbatrossSkinExecutor;
import com.xpn.xwiki.it.selenium.framework.XWikiTestSuite;
import junit.framework.Test;

public class ListSupportTest
extends AbstractWysiwygTestCase {
    public static Test suite() {
        XWikiTestSuite suite = new XWikiTestSuite("Tests valid XHTML list support in the wysiwyg editor.");
        suite.addTestSuite(ListSupportTest.class, AlbatrossSkinExecutor.class);
        return suite;
    }

    public void testEmptyListItemsEditable() {
        this.setWikiContent("** rox");
        this.assertXHTML("<ul><li><br class=\"spacer\"><ul><li>rox</li></ul></li></ul>");
        this.moveCaret("XWE.body.firstChild.firstChild", 0);
        this.typeText("x");
        this.assertXHTML("<ul><li>x<br class=\"spacer\"><ul><li>rox</li></ul></li></ul>");
    }

    public void testEnterBeforeSublist() {
        this.setWikiContent("* x\n** rox");
        this.moveCaret("XWE.body.firstChild.firstChild.firstChild", 1);
        this.typeEnter();
        this.assertXHTML("<ul><li>x</li><li><br class=\"spacer\"><ul><li>rox</li></ul></li></ul>");
        this.moveCaret("XWE.body.firstChild.childNodes[1]", 0);
        this.typeText("w");
        this.assertXHTML("<ul><li>x</li><li>w<br class=\"spacer\"><ul><li>rox</li></ul></li></ul>");
    }

    public void testEnterOnEntireList() {
        this.setWikiContent("* foo\n* bar");
        this.select("XWE.body.firstChild.firstChild.firstChild", 0, "XWE.body.firstChild.lastChild.firstChild", 3);
        this.typeEnter();
        this.typeText("foobar");
        this.assertXHTML("<p><br class=\"spacer\"></p>foobar");
    }

    public void testDeleteInsideItem() {
        this.setWikiContent("* foo**bar**\n** far");
        this.moveCaret("XWE.body.firstChild.firstChild.firstChild", 1);
        this.typeDelete();
        this.assertXHTML("<ul><li>fo<strong>bar</strong><ul><li>far</li></ul></li></ul>");
        this.moveCaret("XWE.body.firstChild.firstChild.firstChild", 2);
        this.typeDelete();
        this.assertXHTML("<ul><li>fo<strong>ar</strong><ul><li>far</li></ul></li></ul>");
    }

    public void testBackspaceInsideItem() {
        this.setWikiContent("* foo\n** b//arf//ar");
        this.moveCaret("XWE.body.firstChild.firstChild.lastChild.firstChild.lastChild", 1);
        this.typeBackspace();
        this.assertXHTML("<ul><li>foo<ul><li>b<em>arf</em>r</li></ul></li></ul>");
        this.typeBackspace();
        this.assertXHTML("<ul><li>foo<ul><li>b<em>ar</em>r</li></ul></li></ul>");
    }

    public void testDeleteInSameList() {
        this.setWikiContent("* foo\n* bar");
        this.moveCaret("XWE.body.firstChild.firstChild.firstChild", 3);
        this.typeDelete();
        this.assertXHTML("<ul><li>foobar</li></ul>");
    }

    public void testBackspaceInSameList() {
        this.setWikiContent("* foo\n* bar");
        this.moveCaret("XWE.body.firstChild.lastChild.firstChild", 0);
        this.typeBackspace();
        this.assertXHTML("<ul><li>foobar</li></ul>");
    }

    public void testDeleteInDifferentLists() {
        this.setWikiContent("* foo\n\n* bar");
        this.moveCaret("XWE.body.firstChild.firstChild.firstChild", 3);
        this.typeDelete();
        this.assertXHTML("<ul><li>foobar</li></ul>");
    }

    public void testBackspaceInDifferentLists() {
        this.setWikiContent("* foo\n\n* bar");
        this.moveCaret("XWE.body.lastChild.firstChild.firstChild", 0);
        this.typeBackspace();
        this.assertXHTML("<ul><li>foobar</li></ul>");
    }

    public void testDeleteBeforeSublist() {
        this.setWikiContent("* foo\n** bar\n");
        this.moveCaret("XWE.body.firstChild.firstChild.firstChild", 3);
        this.typeDelete();
        this.assertXHTML("<ul><li>foobar</li></ul>");
        this.setWikiContent("* foo\n** bar\n** far");
        this.moveCaret("XWE.body.firstChild.firstChild.firstChild", 3);
        this.typeDelete();
        this.assertXHTML("<ul><li>foobar<ul><li>far</li></ul></li></ul>");
    }

    public void testBackspaceBeginSublist() {
        this.setWikiContent("* foo\n** bar\n");
        this.moveCaret("XWE.body.firstChild.firstChild.lastChild.firstChild.firstChild", 0);
        this.typeBackspace();
        this.assertXHTML("<ul><li>foobar</li></ul>");
        this.setWikiContent("* foo\n** bar\n** far");
        this.moveCaret("XWE.body.firstChild.firstChild.lastChild.firstChild.firstChild", 0);
        this.typeBackspace();
        this.assertXHTML("<ul><li>foobar<ul><li>far</li></ul></li></ul>");
    }

    public void testDeleteDecreasesLevelWithEmptyItem() {
        this.setWikiContent("* foo\n*** bar\n");
        this.moveCaret("XWE.body.firstChild.firstChild.firstChild", 3);
        this.typeDelete();
        this.assertXHTML("<ul><li>foo<br class=\"spacer\"><ul><li>bar</li></ul></li></ul>");
    }

    public void testBackspaceDecreasesLevelWithEmptyItem() {
        this.setWikiContent("* foo\n*** bar\n");
        this.moveCaret("XWE.body.firstChild.firstChild.lastChild.firstChild", 0);
        this.typeBackspace();
        this.assertXHTML("<ul><li>foo<br class=\"spacer\"><ul><li>bar</li></ul></li></ul>");
    }

    public void testDeleteBeforePreviousLevelItem() {
        this.setWikiContent("* foo\n** bar\n* bar minus one");
        this.moveCaret("XWE.body.firstChild.firstChild.lastChild.firstChild.firstChild", 3);
        this.typeDelete();
        this.assertXHTML("<ul><li>foo<ul><li>barbar minus one</li></ul></li></ul>");
    }

    public void testBackspaceAfterPreviousLevelItem() {
        this.setWikiContent("* foo\n** bar\n* bar minus one");
        this.moveCaret("XWE.body.firstChild.lastChild.firstChild", 0);
        this.typeBackspace();
        this.assertXHTML("<ul><li>foo<ul><li>barbar minus one</li></ul></li></ul>");
    }

    public void testDeleteAllTextInListItem() {
        this.setWikiContent("* foo\n* b\n** ar");
        this.moveCaret("XWE.body.firstChild.lastChild.firstChild", 0);
        this.typeDelete();
        this.assertXHTML("<ul><li>foo</li><li><br class=\"spacer\"><ul><li>ar</li></ul></li></ul>");
        this.moveCaret("XWE.body.firstChild.lastChild", 0);
        this.typeText("bar");
        this.assertXHTML("<ul><li>foo</li><li>bar<br class=\"spacer\"><ul><li>ar</li></ul></li></ul>");
        this.typeDelete();
        this.assertXHTML("<ul><li>foo</li><li>barar</li></ul>");
    }

    public void testBackspaceAllTextInListItem() {
        this.setWikiContent("* foo\n* b\n** ar");
        this.moveCaret("XWE.body.firstChild.lastChild.firstChild", 1);
        this.typeBackspace();
        this.assertXHTML("<ul><li>foo</li><li><br class=\"spacer\"><ul><li>ar</li></ul></li></ul>");
        this.moveCaret("XWE.body.firstChild.lastChild", 0);
        this.typeText("bar");
        this.assertXHTML("<ul><li>foo</li><li>bar<br class=\"spacer\"><ul><li>ar</li></ul></li></ul>");
        this.moveCaret("XWE.body.firstChild.lastChild.lastChild.firstChild.firstChild", 0);
        this.typeBackspace();
        this.assertXHTML("<ul><li>foo</li><li>barar</li></ul>");
    }

    public void testDeleteBeforeParagraph() {
        this.setWikiContent("* one\n* two\n\nFoobar");
        this.moveCaret("XWE.body.firstChild.lastChild.firstChild", 3);
        this.typeDelete();
        this.assertXHTML("<ul><li>one</li><li>twoFoobar</li></ul>");
        this.setWikiContent("* one\n** two\n\nFoobar");
        this.moveCaret("XWE.body.firstChild.firstChild.lastChild.firstChild.firstChild", 3);
        this.typeDelete();
        this.assertXHTML("<ul><li>one<ul><li>twoFoobar</li></ul></li></ul>");
    }

    public void testBackspaceAfterParagraph() {
        this.setWikiContent("Foobar\n\n* one\n* two");
        this.moveCaret("XWE.body.lastChild.firstChild.firstChild", 0);
        this.typeBackspace();
        this.assertXHTML("<p>Foobarone</p><ul><li>two</li></ul>");
        this.setWikiContent("Foobar\n\n* one\n** two");
        this.moveCaret("XWE.body.lastChild.firstChild.firstChild", 0);
        this.typeBackspace();
        this.assertXHTML("<p>Foobarone</p><ul><li><br class=\"spacer\"><ul><li>two</li></ul></li></ul>");
    }

    public void testDeleteSelectionPreserveSublists() {
        this.setWikiContent("* one\n** two\n** three\n*** four\n*** five");
        this.select("XWE.body.firstChild.firstChild.firstChild", 2, "XWE.body.firstChild.firstChild.lastChild.lastChild.lastChild.firstChild.firstChild", 2);
        this.typeDelete();
        this.assertXHTML("<ul><li>on<ul><li><br class=\"spacer\"><ul><li>ur</li><li>five</li></ul></li></ul></li></ul>");
    }

    public void testDeleteSelectionDeletesEnclosedSublists() {
        this.setWikiContent("* one\n** two\n** three\n*** four\n** five\n* six");
        this.select("XWE.body.firstChild.firstChild.firstChild", 2, "XWE.body.firstChild.lastChild.firstChild", 1);
        this.typeDelete();
        this.assertXHTML("<ul><li>onix</li></ul>");
    }

    public void testIndentNoSublist() {
        this.clickUnorderedListButton();
        this.typeText("foo");
        this.typeEnter();
        this.typeText("bar");
        this.assertXHTML("<ul><li>foo</li><li>bar<br class=\"spacer\"></li></ul>");
        this.clickIndentButton();
        this.assertXHTML("<ul><li>foo<ul><li>bar<br class=\"spacer\"></li></ul></li></ul>");
        ListSupportTest.assertFalse((boolean)this.isIndentButtonEnabled());
        this.moveCaret("XWE.body.firstChild.firstChild.childNodes[1].firstChild.firstChild", 0);
        this.typeTab();
        this.assertXHTML("<ul><li>foo<ul><li>bar<br class=\"spacer\"></li></ul></li></ul>");
        this.assertWiki("* foo\n** bar");
    }

    public void testIndentUnderSublist() {
        this.clickUnorderedListButton();
        this.typeTextThenEnter("one");
        this.typeTextThenEnter("two");
        this.typeTab();
        this.typeTextThenEnter("two plus one");
        this.typeShiftTab();
        this.typeText("three");
        this.clickIndentButton();
        this.assertXHTML("<ul><li>one</li><li>two<ul><li>two plus one</li><li>three<br class=\"spacer\"></li></ul></li></ul>");
        this.assertWiki("* one\n* two\n** two plus one\n** three");
    }

    public void testIndentOutdentWithSublist() {
        this.clickUnorderedListButton();
        this.typeText("foo");
        this.typeEnter();
        this.typeText("bar");
        this.clickIndentButton();
        this.moveCaret("XWE.body.firstChild.firstChild.firstChild", 3);
        this.typeText("one");
        this.moveCaret("XWE.body.firstChild.firstChild.firstChild", 3);
        this.typeEnter();
        this.assertXHTML("<ul><li>foo</li><li>one<ul><li>bar<br class=\"spacer\"></li></ul></li></ul>");
        ListSupportTest.assertTrue((boolean)this.isIndentButtonEnabled());
        this.clickIndentButton();
        this.assertXHTML("<ul><li>foo<ul><li>one<ul><li>bar<br class=\"spacer\"></li></ul></li></ul></li></ul>");
        this.assertWiki("* foo\n** one\n*** bar");
        this.select("XWE.body.firstChild.firstChild.childNodes[1].firstChild.firstChild", 0, "XWE.body.firstChild.firstChild.childNodes[1].firstChild.firstChild", 3);
        ListSupportTest.assertTrue((boolean)this.isOutdentButtonEnabled());
        this.clickOutdentButton();
        this.assertXHTML("<ul><li>foo</li><li>one<ul><li>bar</li></ul></li></ul>");
        this.moveCaret("XWE.body.firstChild.childNodes[1].childNodes[1].firstChild.firstChild", 0);
        this.clickOutdentButton();
        this.assertXHTML("<ul><li>foo</li><li>one</li><li>bar</li></ul>");
        this.assertWiki("* foo\n* one\n* bar");
    }

    public void testOutdentOnFirstLevel() {
        this.clickUnorderedListButton();
        this.typeTextThenEnter("one");
        this.typeTextThenEnter("two");
        this.typeTab();
        this.typeTextThenEnter("two plus one");
        this.typeShiftTab();
        this.typeText("three");
        this.moveCaret("XWE.body.firstChild.childNodes[1].firstChild", 0);
        this.typeShiftTab();
        this.assertXHTML("<ul><li>one</li></ul>two<ul><li>two plus one</li></ul><ul><li>three<br class=\"spacer\"></li></ul>");
        this.assertWiki("* one\n\ntwo\n\n* two plus one\n\n* three");
    }

    public void testDotAtEndDoesNotDelete() {
        this.setWikiContent("* foo\n* bar");
        this.moveCaret("XWE.body.firstChild.firstChild.firstChild", 3);
        this.getSelenium().keyPressNative(Integer.toString(46));
        this.assertXHTML("<ul><li>foo.</li><li>bar</li></ul>");
    }

    public void testListDetection() {
        this.setWikiContent("before\n\n* unordered list item\n*1. ordered sub-list item\n\n1. ordered list item\n1*. unordered sub-list item");
        this.moveCaret("XWE.body.firstChild.firstChild", 3);
        ListSupportTest.assertFalse((boolean)this.isOrderedListDetected());
        ListSupportTest.assertFalse((boolean)this.isUnorderedListDetected());
        this.moveCaret("XWE.body.childNodes[1].firstChild.firstChild", 4);
        ListSupportTest.assertFalse((boolean)this.isOrderedListDetected());
        ListSupportTest.assertTrue((boolean)this.isUnorderedListDetected());
        this.moveCaret("XWE.body.childNodes[1].firstChild.lastChild.firstChild.firstChild", 7);
        ListSupportTest.assertTrue((boolean)this.isOrderedListDetected());
        ListSupportTest.assertTrue((boolean)this.isUnorderedListDetected());
        this.moveCaret("XWE.body.childNodes[2].firstChild.firstChild", 10);
        ListSupportTest.assertTrue((boolean)this.isOrderedListDetected());
        ListSupportTest.assertFalse((boolean)this.isUnorderedListDetected());
        this.moveCaret("XWE.body.childNodes[2].firstChild.lastChild.firstChild.firstChild", 9);
        ListSupportTest.assertTrue((boolean)this.isOrderedListDetected());
        ListSupportTest.assertTrue((boolean)this.isUnorderedListDetected());
    }

    public boolean isOrderedListDetected() {
        return this.isToggleButtonDown("Ordered list");
    }

    public boolean isUnorderedListDetected() {
        return this.isToggleButtonDown("Unordered list");
    }
}

