/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.selenium;

import com.xpn.xwiki.it.selenium.framework.AbstractWysiwygTestCase;
import com.xpn.xwiki.it.selenium.framework.AlbatrossSkinExecutor;
import com.xpn.xwiki.it.selenium.framework.XWikiTestSuite;
import junit.framework.Test;

public class StandardFeaturesTest
extends AbstractWysiwygTestCase {
    public static Test suite() {
        XWikiTestSuite suite = new XWikiTestSuite("Tests wysiwyg essentials features");
        suite.addTestSuite(StandardFeaturesTest.class, AlbatrossSkinExecutor.class);
        return suite;
    }

    public void testEmptyWysiwyg() {
        this.assertWiki("");
    }

    public void testTypingAndDeletion() {
        String text = "foobar";
        this.typeText(text);
        this.assertXHTML(text);
        this.typeBackspace(text.length());
        this.testEmptyWysiwyg();
    }

    public void testParagraphs() {
        this.typeTextThenEnterTwice("a");
        this.typeTextThenEnterTwice("b");
        this.typeText("c");
        this.typeDelete();
        this.assertXHTML("a<p>b</p><p>c</p>");
    }

    public void testEnterOnce() {
        this.typeTextThenEnter("a");
        this.typeText("b");
        this.typeDelete();
        this.assertXHTML("a<br>b");
    }

    public void testEnterTwice() {
        this.typeTextThenEnterTwice("a");
        this.typeText("b");
        this.typeDelete();
        this.assertXHTML("a<p>b</p>");
    }

    public void testEnterThrice() {
        this.typeTextThenEnterTwice("a");
        this.typeEnter();
        this.typeText("b");
        this.assertWiki("a\n\n\nb");
    }

    public void testBold() {
        this.typeText("foobar");
        this.applyStyleParagraph();
        this.selectElement("p", 1);
        this.clickBoldButton();
        this.assertXHTML("<p><strong>foobar</strong></p>");
    }

    public void testItalics() {
        this.typeText("foobar");
        this.applyStyleParagraph();
        this.selectElement("p", 1);
        this.clickItalicsButton();
        this.assertXHTML("<p><em>foobar</em></p>");
    }

    public void testUnderline() {
        this.typeText("foobar");
        this.applyStyleParagraph();
        this.selectElement("p", 1);
        this.clickUnderlineButton();
        this.assertXHTML("<p><ins>foobar</ins></p>");
    }

    public void testStrikethrough() {
        this.typeText("foobar");
        this.applyStyleParagraph();
        this.selectElement("p", 1);
        this.clickStrikethroughButton();
        this.assertXHTML("<p><del>foobar</del></p>");
    }

    public void testSubscript() {
        this.typeText("foobar");
        this.applyStyleParagraph();
        this.selectElement("p", 1);
        this.clickSubscriptButton();
        this.assertXHTML("<p><sub>foobar</sub></p>");
    }

    public void testSuperscript() {
        this.typeText("foobar");
        this.applyStyleParagraph();
        this.selectElement("p", 1);
        this.clickSuperscriptButton();
        this.assertXHTML("<p><sup>foobar</sup></p>");
    }

    public void testUnorderedList() {
        this.typeTextThenEnter("a");
        this.typeTextThenEnter("b");
        this.typeText("c");
        this.typeDelete();
        this.selectAllContent();
        this.clickUnorderedListButton();
        this.assertXHTML("<ul><li>a</li><li>b</li><li>c</li></ul>");
        this.clickUnorderedListButton();
        this.assertXHTML("a<br>b<br>c");
        this.resetContent();
        this.typeText("a");
        this.selectAllContent();
        this.clickUnorderedListButton();
        this.typeBackspace(2);
        this.testEmptyWysiwyg();
    }

    public void testOrderedList() {
        this.typeTextThenEnter("a");
        this.typeTextThenEnter("b");
        this.typeText("c");
        this.typeDelete();
        this.selectAllContent();
        this.clickOrderedListButton();
        this.assertXHTML("<ol><li>a</li><li>b</li><li>c</li></ol>");
        this.clickOrderedListButton();
        this.assertXHTML("a<br>b<br>c");
        this.resetContent();
        this.typeText("a");
        this.selectAllContent();
        this.clickOrderedListButton();
        this.typeBackspace(2);
        this.testEmptyWysiwyg();
    }

    public void testStyle() {
        this.typeText("foobar");
        this.selectAllContent();
        this.applyStyleTitle1();
        this.assertXHTML("<h1>foobar</h1>");
        this.applyStyleTitle2();
        this.assertXHTML("<h2>foobar</h2>");
        this.applyStyleTitle3();
        this.assertXHTML("<h3>foobar</h3>");
        this.applyStyleTitle4();
        this.assertXHTML("<h4>foobar</h4>");
        this.applyStyleTitle5();
        this.assertXHTML("<h5>foobar</h5>");
        this.applyStyleParagraph();
        this.assertXHTML("<p>foobar</p>");
        this.applyStyleInLine();
        this.assertXHTML("foobar");
    }

    public void testHR() {
        this.clickHRButton();
        this.assertXHTML("<hr><br class=\"spacer\">");
        this.typeBackspace(2);
        this.testEmptyWysiwyg();
        this.typeText("foobar");
        this.typeDelete();
        this.applyStyleTitle1();
        this.moveCaret("XWE.selection.getRangeAt(0).startContainer", 3);
        this.clickHRButton();
        this.assertXHTML("<h1>foo</h1><hr><h1>bar</h1>");
    }

    public void testInsertSymbol() {
        this.clickSymbolButton();
        this.getSelenium().click("//div[@title='copyright sign']");
        this.clickSymbolButton();
        this.closeDialog();
        this.clickSymbolButton();
        this.getSelenium().click("//div[@title='registered sign']");
        this.assertWiki("\u00a9\u00ae");
    }

    public void testEnterOnEmptyLine() {
        this.typeEnter();
        this.typeText("foobar");
        this.applyStyleTitle1();
        this.typeEnter(2);
        this.typeText("x");
        this.assertWiki("\n= foobar =\n\nx");
    }

    public void testEnterAfterImage() {
        this.clickInsertImageButton();
        String spaceSelector = "//div[@class=\"xImageChooser\"]//select[2]";
        String space = "XWiki";
        this.waitForCondition("selenium.isElementPresent('" + spaceSelector + "/option[@value=\"" + space + "\"]');");
        this.getSelenium().select(spaceSelector, space);
        String pageSelector = "//div[@class=\"xImageChooser\"]//select[3]";
        String page = "AdminSheet";
        this.waitForCondition("selenium.isElementPresent('" + pageSelector + "/option[@value=\"" + page + "\"]');");
        this.getSelenium().select(pageSelector, page);
        this.getSelenium().click("//div[@class=\"xImageChooser\"]//button[text()=\"Update\"]");
        String imageSelector = "//div[@class=\"xImagesContainerPanel\"]//img[@title=\"photos.png\"]";
        this.waitForCondition("selenium.isElementPresent('" + imageSelector + "');");
        this.getSelenium().click(imageSelector);
        this.getSelenium().click("//div[@class=\"xImageDialogMain\"]/button[text()=\"OK\"]");
        this.runScript("XWE.selection.collapseToEnd()");
        this.typeEnter(2);
        this.typeText("xyz");
        this.typeDelete();
        this.assertXHTML("<!--startimage:XWiki.AdminSheet@photos.png--><img src=\"/xwiki/bin/download/XWiki/AdminSheet/photos.png\" alt=\"photos.png\"><!--stopimage--><p>xyz</p>");
    }

    public void testTabDefault() {
        this.typeText("a");
        this.typeTab();
        this.typeText("b");
        this.typeShiftTab();
        this.typeText("c");
        this.assertXHTML("a&nbsp;&nbsp;&nbsp; bc");
    }

    public void testTabInListItem() {
        this.typeTextThenEnter("x");
        this.typeText("y");
        this.selectAllContent();
        this.clickUnorderedListButton();
        this.moveCaret("XWE.body.firstChild.childNodes[1].firstChild", 0);
        this.typeTab();
        this.assertXHTML("<ul><li>x<ul><li>y</li></ul></li></ul>");
        this.typeShiftTab();
        this.assertXHTML("<ul><li>x</li><li>y</li></ul>");
    }

    public void testTabInTableCell() {
        this.clickInsertTableButton();
        this.getSelenium().click("//div[@class=\"xTableMainPanel\"]/button[text()=\"Insert\"]");
        this.typeText("a");
        this.typeShiftTab();
        this.typeText("b");
        this.typeTab(3);
        this.typeText("c");
        this.typeTab();
        this.typeText("d");
        this.typeShiftTab(4);
        this.typeText("e");
        this.assertWiki("|=e ab|= \n| |c \n|d | ");
    }

    public void testEmptyLinesAreEditable() {
        this.setWikiContent("a\n\n\n\nb");
        this.assertXHTML("<p>a</p><p><br class=\"spacer\"></p><p><br class=\"spacer\"></p><p>b</p>");
    }

    public void testRecoverAfterConversionException() {
        String html = "<span class=\"wikiexternallink\"><a href=\"mailto:x@y.z\">xyz</a></span><!--stopwikilink-->";
        this.setContent(html);
        this.assertXHTML(html);
        this.clickEditSaveAndContinue();
        this.assertXHTML(html);
    }

    public void testUnwantedBRsAreRemoved() {
        this.typeTextThenEnter("a");
        this.typeTextThenEnter("b");
        this.assertWiki("a\nb\\\\");
    }

    public void testEmptyParagraphsGenerateEmptyLines() {
        this.setWikiContent("(% style=\"color: blue; text-align: center;\" %)\nHello world");
        this.moveCaret("XWE.body.firstChild.firstChild", 6);
        this.typeEnter(4);
        this.assertWiki("(% style=\"color: blue; text-align: center;\" %)\nHello\n\n\n\nworld");
    }

    public void testUndoRedo() {
        this.typeText("alice bob");
        this.typeTab();
        this.typeText("carol");
        this.clickSymbolButton();
        this.getSelenium().click("//div[@title='copyright sign']");
        this.applyStyleTitle1();
        this.clickUndoButton(4);
        this.assertXHTML("alice bob<br class=\"spacer\">");
        this.clickUndoButton(3);
        this.assertXHTML("<br class=\"spacer\">");
        this.clickRedoButton(7);
        this.assertXHTML("<h1>alice bob&nbsp;&nbsp;&nbsp; carol\u00a9<br class=\"spacer\"></h1>");
    }

    public void testUndoRedoShortcutKeys() {
        this.typeText("March 9th, 2009");
        this.select("XWE.body.firstChild", 0, "XWE.body.firstChild", 5);
        this.getSelenium().controlKeyDown();
        this.typeText("B");
        this.getSelenium().controlKeyUp();
        this.getSelenium().metaKeyDown();
        this.typeText("I");
        this.getSelenium().metaKeyUp();
        this.getSelenium().controlKeyDown();
        this.typeText("U");
        this.getSelenium().controlKeyUp();
        this.getSelenium().metaKeyDown();
        this.typeText("ZZZ");
        this.getSelenium().metaKeyUp();
        this.getSelenium().controlKeyDown();
        this.typeText("YY");
        this.getSelenium().controlKeyUp();
        this.assertWiki("**//March//** 9th, 2009");
    }

    public void testPreview() {
        this.typeText("x");
        this.selectAllContent();
        this.clickBoldButton();
        this.clickEditPreview();
        this.clickBackToEdit();
        this.assertWiki("**x**");
    }

    public void testEnterOnCrossParagraphSelection() {
        this.typeText("ab");
        this.applyStyleParagraph();
        this.typeEnter(2);
        this.typeText("cd");
        this.select("XWE.body.firstChild.firstChild", 1, "XWE.body.lastChild.firstChild", 1);
        this.typeEnter();
        this.assertWiki("a\nd");
    }

    public void testEnterOnCrossTableCellSelection() {
        this.clickInsertTableButton();
        this.getSelenium().click("//div[@class=\"xTableMainPanel\"]/button[text()=\"Insert\"]");
        this.typeText("ab");
        this.typeTab();
        this.typeText("cd");
        this.select("XWE.body.firstChild.rows[0].cells[0].lastChild", 1, "XWE.body.firstChild.rows[0].cells[1].firstChild", 1);
        this.typeEnter();
        this.typeText("x");
        this.assertWiki("|= a\nx|=d \n| | ");
    }

    public void testInsertHRInPlaceOfASelectedList() {
        this.typeTextThenEnter("foo");
        this.typeText("bar");
        this.selectAllContent();
        this.clickUnorderedListButton();
        this.clickHRButton();
        this.assertWiki("----");
    }

    public void testEnterTwiceInHeader() {
        this.typeText("header");
        this.applyStyleTitle1();
        this.assertWiki("= header =");
        this.moveCaret("XWE.body.firstChild.firstChild.firstChild", 3);
        this.typeText("#");
        StandardFeaturesTest.assertEquals((String)"h1", (String)this.getSelenium().getValue("//select[@title=\"Apply Style\"]"));
        this.typeEnter(2);
        StandardFeaturesTest.assertEquals((String)"p", (String)this.getSelenium().getValue("//select[@title=\"Apply Style\"]"));
        this.assertWiki("= hea# =\n\nder");
    }

    public void testMoveCaretBeforeAndAfterTable() {
        this.setWikiContent("|=Space|=Page\n|Main|WebHome");
        this.moveCaret("XWE.body.firstChild.rows[0].cells[0].firstChild", 2);
        this.getSelenium().controlKeyDown();
        this.typeUpArrow();
        this.getSelenium().controlKeyUp();
        this.typeText("before");
        this.moveCaret("XWE.body.lastChild.rows[1].cells[1].firstChild", 3);
        this.getSelenium().controlKeyDown();
        this.typeDownArrow();
        this.getSelenium().controlKeyUp();
        this.typeText("after");
        this.assertWiki("before\n\n|=Space|=Page\n|Main|WebHome\n\nafter");
    }

    public void testInsertHRInsideParagraph() {
        this.typeText("xy");
        this.applyStyleParagraph();
        this.clickHRButton();
        this.moveCaret("XWE.body.firstChild.firstChild", 1);
        this.clickHRButton();
        this.moveCaret("XWE.body.firstChild.firstChild", 0);
        this.clickHRButton();
        this.assertXHTML("<p><br class=\"spacer\"></p><hr><p>x</p><hr><p>y</p><hr><p><br class=\"spacer\"></p>");
    }

    public void testNewLinesAtTheEndOfListItemsArePreserved() {
        String wikiText = "* \\\\\n** \\\\\n*** test1";
        this.setWikiContent(wikiText);
        this.assertWiki(wikiText);
    }

    public void testDialogContentIsPreservedAfterBeingMoved() {
        this.clickOfficeImporterButton();
        this.runScript("\nvar iframes = document.getElementsByTagName('iframe');\nfor (var i = 0; i < iframes.length; i++) {\n\tvar iframe = iframes[i];\n\tif (iframe.className == 'gwt-RichTextArea xImporterClipboardTabEditor') {\n\t\tiframe.contentWindow.document.body.innerHTML = 'office';\n\t\tbreak;\n\t}\n}\n");
        this.getSelenium().dragdrop("//div[@class='gwt-Label xDialogCaption']", "100, 100");
        StandardFeaturesTest.assertEquals((String)"office", (String)this.getSelenium().getEval("window.iframe.contentWindow.document.body.innerHTML"));
        this.closeDialog();
        this.waitForDialogToClose();
    }

    public void testRemoveBoldStyleWhenTheStyleAttributeIsUsed() {
        this.setWikiContent("hello (% style=\"font-weight: bold; font-family: monospace;\" %)vincent(%%) world");
        this.selectNodeContents("XWE.body.firstChild.childNodes[1]");
        StandardFeaturesTest.assertTrue((boolean)this.isBoldDetected());
        this.clickBoldButton();
        StandardFeaturesTest.assertFalse((boolean)this.isBoldDetected());
        this.assertWiki("hello (% style=\"font-weight: normal; font-family: monospace;\" %)vincent(%%) world");
    }

    public void testRemoveBoldStyleWithinHeading() {
        this.setWikiContent("(% style=\"font-weight: bold;\" %)\n= Title 1 =");
        this.select("XWE.body.firstChild.firstChild.firstChild", 3, "XWE.body.firstChild.firstChild.firstChild", 5);
        StandardFeaturesTest.assertTrue((boolean)this.isBoldDetected());
        this.clickBoldButton();
        StandardFeaturesTest.assertFalse((boolean)this.isBoldDetected());
        this.assertWiki("(% style=\"font-weight: bold;\" %)\n= Tit(% style=\"font-weight: normal;\" %)le(%%) 1 =");
    }

    public void testRemoveUnderlineStyleFromALink() {
        this.setWikiContent("[[foo>>mailto:x@y.z||title=\"bar\"]]");
        this.selectNode("XWE.body.getElementsByTagName('a')[0]");
        StandardFeaturesTest.assertTrue((boolean)this.isUnderlineDetected());
        this.clickUnderlineButton();
        StandardFeaturesTest.assertTrue((boolean)this.isUnderlineDetected());
        this.assertWiki("[[foo>>mailto:x@y.z||style=\"text-decoration: none;\" title=\"bar\"]]");
    }
}

