/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xmlrpc;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlrpc.XmlRpcException;
import org.codehaus.swizzle.confluence.Page;
import org.xwiki.xmlrpc.AbstractXWikiXmlRpcTest;
import org.xwiki.xmlrpc.TestUtils;
import org.xwiki.xmlrpc.model.XWikiObject;
import org.xwiki.xmlrpc.model.XWikiObjectSummary;
import org.xwiki.xmlrpc.model.XWikiPage;

public class XWikiObjectsTest
extends AbstractXWikiXmlRpcTest {
    public void setUp() throws XmlRpcException, MalformedURLException {
        super.setUp();
        try {
            this.rpc.getPage("Test.Objects");
        }
        catch (Exception e) {
            XWikiPage page = new XWikiPage();
            page.setId("Test.Objects");
            page.setTitle("Test page with objects");
            page.setContent("Test page with objects");
            this.rpc.storePage((Page)page);
        }
    }

    public void testCreateTagsObject() throws XmlRpcException {
        XWikiObject tagsObject = new XWikiObject();
        tagsObject.setPageId("Test.Objects");
        tagsObject.setClassName("XWiki.TagClass");
        tagsObject.setPrettyName("PrettyName");
        ArrayList<String> tags = new ArrayList<String>();
        tags.add(String.format("New-%d", this.random.nextInt()));
        tagsObject.setProperty("tags", tags);
        tagsObject = this.rpc.storeObject(tagsObject);
        TestUtils.banner("createTagsObject()");
        System.out.format("%s\n", tagsObject);
        XWikiObjectsTest.assertTrue((tagsObject.getId() != -1 ? 1 : 0) != 0);
        XWikiObjectsTest.assertEquals(tags, (Object)tagsObject.getProperty("tags"));
    }

    public void testGetXWikiObjects() throws XmlRpcException {
        List xwikiObjects = this.rpc.getObjects("Test.Objects");
        TestUtils.banner("TEST: getXWikiObjects()");
        for (XWikiObjectSummary xwikiObjectSummary : xwikiObjects) {
            System.out.format("%s\n", xwikiObjectSummary);
        }
        XWikiObjectsTest.assertFalse((boolean)xwikiObjects.isEmpty());
    }

    public void testGetXWikiTagObject() throws XmlRpcException {
        List xwikiObjects = this.rpc.getObjects("Test.Objects");
        XWikiObjectSummary tagsObjectSummary = null;
        for (XWikiObjectSummary xwikiObjectSummary : xwikiObjects) {
            if (!xwikiObjectSummary.getClassName().equals("XWiki.TagClass")) continue;
            tagsObjectSummary = xwikiObjectSummary;
        }
        XWikiObject tagsObject = this.rpc.getObject(tagsObjectSummary);
        TestUtils.banner("TEST: getXWikiTagObject()");
        System.out.format("%s\n", tagsObject);
        XWikiObjectsTest.assertEquals((String)tagsObjectSummary.getPageId(), (String)tagsObject.getPageId());
        XWikiObjectsTest.assertEquals((int)tagsObjectSummary.getId(), (int)tagsObject.getId());
        XWikiObjectsTest.assertEquals((String)tagsObjectSummary.getClassName(), (String)tagsObject.getClassName());
    }

    public void testSetTagsObject() throws XmlRpcException {
        List xwikiObjects = this.rpc.getObjects("Test.Objects");
        XWikiObjectSummary tagsObjectSummary = null;
        for (XWikiObjectSummary xwikiObjectSummary : xwikiObjects) {
            if (!xwikiObjectSummary.getClassName().equals("XWiki.TagClass")) continue;
            tagsObjectSummary = xwikiObjectSummary;
        }
        XWikiObject object = this.rpc.getObject(tagsObjectSummary);
        TestUtils.banner("TEST: setTagsObject()");
        System.out.format("%s\n", object);
        Object value = object.getProperty("tags");
        XWikiObjectsTest.assertTrue((boolean)(value instanceof List));
        List tags = (List)value;
        tags.add(new Integer(this.random.nextInt()).toString());
        this.rpc.storeObject(object);
        object = this.rpc.getObject(tagsObjectSummary);
        List newTags = (List)object.getProperty("tags");
        XWikiObjectsTest.assertTrue((newTags.size() == tags.size() ? 1 : 0) != 0);
        for (Object t : tags) {
            XWikiObjectsTest.assertTrue((boolean)newTags.contains(t));
        }
    }

    public void testRemoveObject() throws XmlRpcException {
        XWikiObject tagsObject = new XWikiObject();
        tagsObject.setPageId("Test.Objects");
        tagsObject.setClassName("XWiki.TagClass");
        tagsObject.setPrettyName("PrettyName");
        ArrayList<String> tags = new ArrayList<String>();
        tags.add(String.format("New-%d", this.random.nextInt()));
        tagsObject.setProperty("tags", tags);
        tagsObject = this.rpc.storeObject(tagsObject);
        Boolean result = this.rpc.removeObject((XWikiObjectSummary)tagsObject);
        TestUtils.banner("removeObjectTest()");
        System.out.format("Object added: %s\n", tagsObject);
        System.out.format("Object removed = %b\n", result);
        List objects = this.rpc.getObjects(tagsObject.getPageId());
        boolean found = false;
        for (XWikiObjectSummary object : objects) {
            if (!object.getClassName().equals(tagsObject.getClassName()) || object.getId() != tagsObject.getId()) continue;
            found = true;
            break;
        }
        XWikiObjectsTest.assertFalse((boolean)found);
    }
}

