/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.xmlrpc;

import com.xpn.xwiki.it.xmlrpc.XhtmlValidityTest;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.Page;

public class OrphanedPageTest
extends TestCase {
    private String fullPageName;
    private Confluence rpc;

    public OrphanedPageTest(String fullPageName) {
        super("testPageIsOrphaned");
        this.fullPageName = fullPageName;
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite();
        String path = System.getProperty("localRepository") + "/" + System.getProperty("pathToXWikiXar");
        String patternFilter = System.getProperty("documentsToTest");
        List pageNames = XhtmlValidityTest.readXarContents(path, patternFilter);
        Iterator it = pageNames.iterator();
        while (it.hasNext()) {
            suite.addTest((Test)new OrphanedPageTest((String)it.next()));
        }
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.rpc = new Confluence("http://127.0.0.1:8080/xwiki/xmlrpc");
        this.rpc.login("Admin", "admin");
        System.out.println(this.getName());
    }

    protected void tearDown() throws Exception {
        this.rpc.logout();
        super.tearDown();
    }

    public String getName() {
        return "Checking orphans for " + this.fullPageName;
    }

    public void testPageIsOrphaned() throws Exception {
        Page page = this.rpc.getPage(this.fullPageName);
        OrphanedPageTest.assertTrue((String)("Page " + page.getId() + " is orphaned!"), (OrphanedPageTest.isRoot(page) || OrphanedPageTest.hasParent(page) ? 1 : 0) != 0);
    }

    public static boolean isRoot(Page page) {
        String pageId = page.getId();
        String pageName = pageId.substring(pageId.lastIndexOf(".") + 1);
        return pageName.equals("WebHome");
    }

    public static boolean hasParent(Page page) {
        String parentId = page.getParentId();
        return parentId != null && parentId.length() > 0;
    }
}

