/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xmlrpc;

import java.util.List;
import org.codehaus.swizzle.confluence.SearchResult;
import org.codehaus.swizzle.confluence.SpaceSummary;
import org.xwiki.xmlrpc.AbstractXWikiXmlRpcTest;
import org.xwiki.xmlrpc.TestUtils;
import org.xwiki.xmlrpc.model.XWikiPageSummary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchTest
extends AbstractXWikiXmlRpcTest {
    public void testSearch() throws Exception {
        List result = this.rpc.search("a", Integer.valueOf(10));
        TestUtils.banner("TEST: search()");
        System.out.format("%s\n", result);
        SearchTest.assertFalse((boolean)result.isEmpty());
    }

    public void testSearchAllPageIds() throws Exception {
        List result = this.rpc.searchAllPagesIds();
        TestUtils.banner("TEST: searchAllPageIds()");
        System.out.format("%s\n", result);
        List spaces = this.rpc.getSpaces();
        for (SpaceSummary spaceSummary : spaces) {
            List pages = this.rpc.getPages(spaceSummary);
            for (XWikiPageSummary page : pages) {
                SearchTest.assertTrue((boolean)this.checkMembership(page.getId(), result));
            }
        }
    }

    private boolean checkMembership(String pageId, List<SearchResult> searchResults) {
        for (SearchResult searchResult : searchResults) {
            if (!searchResult.getId().equals(pageId)) continue;
            return true;
        }
        System.out.format("%s not in result\n", pageId);
        return false;
    }
}

