/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.javassist;

import com.zaxxer.hikari.javassist.HikariClassTransformer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariClassScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariClassScanner.class);
    private HikariClassTransformer transformer;
    private Map<String, Set<String>> codex;
    private String shadedCodexMapping;

    public HikariClassScanner(HikariClassTransformer transformer, String shadedCodexMapping) {
        this.transformer = transformer;
        this.shadedCodexMapping = shadedCodexMapping;
    }

    public boolean scanClasses(String dsClassName) {
        try {
            long start = System.currentTimeMillis();
            if (!this.loadCodex()) {
                LOGGER.warn("Unable to load instrumentation codex.  Please report at http://github.com/brettwooldridge/HikariCP.");
                LOGGER.info("Using delegation instead of instrumentation");
                return false;
            }
            String keyPrefix = this.getKeyPrefix(dsClassName);
            if (keyPrefix == null) {
                LOGGER.warn("DataSource {} not found in the instrumentation codex.  Please report at http://github.com/brettwooldridge/HikariCP.", (Object)dsClassName);
                LOGGER.info("Using delegation instead of instrumentation");
                return false;
            }
            HashSet classes = (HashSet)this.codex.get(keyPrefix + ".baseConnection");
            this.loadClasses(classes, 1);
            classes = (HashSet)this.codex.get(keyPrefix + ".subConnection");
            this.loadClasses(classes, 6);
            classes = (HashSet)this.codex.get(keyPrefix + ".baseStatement");
            this.loadClasses(classes, 2);
            classes = (HashSet)this.codex.get(keyPrefix + ".subStatement");
            this.loadClasses(classes, 7);
            classes = (HashSet)this.codex.get(keyPrefix + ".basePreparedStatement");
            this.loadClasses(classes, 3);
            classes = (HashSet)this.codex.get(keyPrefix + ".subPreparedStatement");
            this.loadClasses(classes, 8);
            classes = (HashSet)this.codex.get(keyPrefix + ".baseCallableStatement");
            this.loadClasses(classes, 4);
            classes = (HashSet)this.codex.get(keyPrefix + ".subCallableStatement");
            this.loadClasses(classes, 9);
            classes = (HashSet)this.codex.get(keyPrefix + ".baseResultSet");
            this.loadClasses(classes, 5);
            classes = (HashSet)this.codex.get(keyPrefix + ".subResultSet");
            this.loadClasses(classes, 10);
            LOGGER.info("Instrumented JDBC classes in {}ms.", (Object)(System.currentTimeMillis() - start));
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Unable to instrument classes", (Throwable)e);
            return false;
        }
    }

    private String getKeyPrefix(String dsClassName) {
        if (this.shadedCodexMapping == null) {
            HashSet hash = (HashSet)this.codex.get(dsClassName);
            return hash == null ? null : (String)hash.iterator().next();
        }
        String[] split = this.shadedCodexMapping.split(":");
        String origPackage = split[0];
        String shadePackage = split[1];
        for (String key : this.codex.keySet()) {
            if (!key.replace(origPackage, shadePackage).equals(dsClassName)) continue;
            HashSet hash = (HashSet)this.codex.get(key);
            return (String)hash.iterator().next();
        }
        return null;
    }

    private boolean loadCodex() throws IOException {
        String line;
        this.codex = new HashMap<String, Set<String>>();
        InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/codex.properties");
        if (inputStream == null) {
            return false;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        do {
            if ((line = reader.readLine()) == null || (line = line.trim()).startsWith("#") || line.length() == 0) continue;
            String[] split = line.split("=");
            String key = split[0];
            String value = split[1];
            HashSet existing = (HashSet)this.codex.get(key);
            if (existing == null) {
                HashSet<String> array = new HashSet<String>();
                array.add(value);
                this.codex.put(key, array);
                continue;
            }
            existing.add(value);
        } while (line != null);
        return true;
    }

    private void loadClasses(HashSet<String> classes, int classType) throws ClassNotFoundException {
        if (classes == null) {
            return;
        }
        if (this.shadedCodexMapping != null) {
            String[] split = this.shadedCodexMapping.split(":");
            String origPackage = split[0];
            String shadePackage = split[1];
            HashSet<String> shadedClasses = new HashSet<String>();
            for (String clazz : classes) {
                shadedClasses.add(clazz.replace(origPackage, shadePackage));
            }
            classes = shadedClasses;
        }
        this.transformer.setScanClass(classes, classType);
        for (String clazz : classes) {
            this.getClass().getClassLoader().loadClass(clazz);
        }
    }
}

