/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.HikariPool;
import com.zaxxer.hikari.javassist.HikariInject;
import com.zaxxer.hikari.javassist.HikariOverride;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.IHikariStatementProxy;
import com.zaxxer.hikari.proxy.JavassistProxyFactoryFactory;
import com.zaxxer.hikari.proxy.LeakTask;
import com.zaxxer.hikari.proxy.ProxyFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public abstract class ConnectionProxy
implements IHikariConnectionProxy,
Connection {
    private static ProxyFactory PROXY_FACTORY;
    @HikariInject
    protected static final Set<String> SQL_ERRORS;
    @HikariInject
    protected volatile boolean _isClosed;
    @HikariInject
    protected ArrayList<Statement> _openStatements;
    @HikariInject
    protected HikariPool _parentPool;
    @HikariInject
    protected volatile boolean _forceClose;
    @HikariInject
    protected long _creationTime;
    @HikariInject
    protected long _lastAccess;
    @HikariInject
    protected StackTraceElement[] _stackTrace;
    @HikariInject
    protected TimerTask _leakTask;
    protected final Connection delegate;

    protected ConnectionProxy(Connection connection) {
        this.delegate = connection;
        this.__init();
    }

    @Override
    @HikariInject
    public void _unregisterStatement(Object statement) {
        if (!this._isClosed) {
            this._openStatements.remove(statement);
        }
    }

    @Override
    @HikariInject
    public long _getCreationTime() {
        return this._creationTime;
    }

    @Override
    @HikariInject
    public long _getLastAccess() {
        return this._lastAccess;
    }

    @Override
    @HikariInject
    public void _markLastAccess() {
        this._lastAccess = System.currentTimeMillis();
    }

    @Override
    @HikariInject
    public void _setParentPool(HikariPool parentPool) {
        this._parentPool = parentPool;
    }

    @Override
    @HikariInject
    public void _unclose() {
        this._isClosed = false;
    }

    @Override
    @HikariInject
    public void _captureStack(long leakDetectionThreshold, Timer scheduler) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        this._stackTrace = new StackTraceElement[trace.length - 4];
        System.arraycopy(trace, 4, this._stackTrace, 0, this._stackTrace.length);
        this._leakTask = new LeakTask(this._stackTrace, leakDetectionThreshold);
        scheduler.schedule(this._leakTask, leakDetectionThreshold);
    }

    @Override
    @HikariInject
    public boolean _isBrokenConnection() {
        return this._forceClose;
    }

    @Override
    @HikariInject
    public SQLException _checkException(SQLException sqle) {
        String sqlState = sqle.getSQLState();
        this._forceClose |= sqlState != null && (sqlState.startsWith("08") || SQL_ERRORS.contains(sqlState));
        return sqle;
    }

    @HikariInject
    protected void __init() {
        if (this._openStatements == null) {
            this._openStatements = new ArrayList(64);
            this._creationTime = this._lastAccess = System.currentTimeMillis();
        }
    }

    @HikariInject
    protected void _checkClosed() throws SQLException {
        if (this._isClosed) {
            throw new SQLException("Connection is closed");
        }
    }

    @HikariInject
    protected <T extends Statement> T _trackStatement(T statement) {
        IHikariStatementProxy statementProxy = (IHikariStatementProxy)((Object)statement);
        if (statementProxy._getConnectionProxy() == null) {
            statementProxy._setConnectionProxy(this);
            this._openStatements.add(statement);
        }
        return statement;
    }

    @Override
    @HikariOverride
    public void close() throws SQLException {
        if (!this._isClosed) {
            this._isClosed = true;
            if (this._leakTask != null) {
                this._leakTask.cancel();
                this._leakTask = null;
            }
            try {
                int length = this._openStatements.size();
                for (int i = 0; i < length; ++i) {
                    this._openStatements.get(i).close();
                }
            }
            catch (SQLException e) {
                throw this._checkException(e);
            }
            finally {
                this._openStatements.clear();
                this._parentPool.releaseConnection(this);
            }
        }
    }

    @Override
    @HikariOverride
    public boolean isClosed() throws SQLException {
        return this._isClosed;
    }

    @Override
    @HikariOverride
    public Statement createStatement() throws SQLException {
        this._checkClosed();
        try {
            Statement statement = this.__createStatement();
            return this._trackStatement(statement);
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    @Override
    @HikariOverride
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this._checkClosed();
        try {
            Statement statement = this.__createStatement(resultSetType, resultSetConcurrency);
            return this._trackStatement(statement);
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    @Override
    @HikariOverride
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this._checkClosed();
        try {
            Statement statement = this.__createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            return this._trackStatement(statement);
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    @Override
    @HikariOverride
    public CallableStatement prepareCall(String sql) throws SQLException {
        this._checkClosed();
        try {
            CallableStatement statement = this.__prepareCall(sql);
            return this._trackStatement(statement);
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    @Override
    @HikariOverride
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this._checkClosed();
        try {
            CallableStatement statement = this.__prepareCall(sql, resultSetType, resultSetConcurrency);
            return this._trackStatement(statement);
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    @Override
    @HikariOverride
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this._checkClosed();
        try {
            CallableStatement statement = this.__prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            return this._trackStatement(statement);
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    @Override
    @HikariOverride
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this._checkClosed();
        try {
            PreparedStatement statement = this.__prepareStatement(sql);
            return this._trackStatement(statement);
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    @Override
    @HikariOverride
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this._checkClosed();
        try {
            PreparedStatement statement = this.__prepareStatement(sql, autoGeneratedKeys);
            return this._trackStatement(statement);
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    @Override
    @HikariOverride
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this._checkClosed();
        try {
            PreparedStatement statement = this.__prepareStatement(sql, resultSetType, resultSetConcurrency);
            return this._trackStatement(statement);
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    @Override
    @HikariOverride
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this._checkClosed();
        try {
            PreparedStatement statement = this.__prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            return this._trackStatement(statement);
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    @Override
    @HikariOverride
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this._checkClosed();
        try {
            PreparedStatement statement = this.__prepareStatement(sql, columnIndexes);
            return this._trackStatement(statement);
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    @Override
    @HikariOverride
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this._checkClosed();
        try {
            PreparedStatement statement = this.__prepareStatement(sql, columnNames);
            return this._trackStatement(statement);
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    @Override
    @HikariOverride
    public boolean isValid(int timeout) throws SQLException {
        if (this._isClosed) {
            return false;
        }
        try {
            return this.__isValid(timeout);
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    private static void __static() {
        if (PROXY_FACTORY == null) {
            PROXY_FACTORY = JavassistProxyFactoryFactory.getProxyFactory();
        }
    }

    @Override
    public final void __close() throws SQLException {
        this.delegate.close();
    }

    public final boolean __isValid(int timeout) throws SQLException {
        return this.delegate.isValid(timeout);
    }

    public final Statement __createStatement() throws SQLException {
        return PROXY_FACTORY.getProxyStatement(this, this.delegate.createStatement());
    }

    public final Statement __createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return PROXY_FACTORY.getProxyStatement(this, this.delegate.createStatement(resultSetType, resultSetConcurrency));
    }

    public final Statement __createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return PROXY_FACTORY.getProxyStatement(this, this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    public final CallableStatement __prepareCall(String sql) throws SQLException {
        return PROXY_FACTORY.getProxyCallableStatement(this, this.delegate.prepareCall(sql));
    }

    public final CallableStatement __prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return PROXY_FACTORY.getProxyCallableStatement(this, this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency));
    }

    public final CallableStatement __prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return PROXY_FACTORY.getProxyCallableStatement(this, this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    public final PreparedStatement __prepareStatement(String sql) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql));
    }

    public final PreparedStatement __prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, autoGeneratedKeys));
    }

    public final PreparedStatement __prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency));
    }

    public final PreparedStatement __prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    public final PreparedStatement __prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, columnIndexes));
    }

    public final PreparedStatement __prepareStatement(String sql, String[] columnNames) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, columnNames));
    }

    static {
        SQL_ERRORS = new HashSet<String>();
        SQL_ERRORS.add("57P01");
        SQL_ERRORS.add("57P02");
        SQL_ERRORS.add("57P03");
        SQL_ERRORS.add("57P02");
        SQL_ERRORS.add("01002");
        ConnectionProxy.__static();
    }
}

