/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import java.sql.Statement;

public final class FastStatementList {
    private Statement[] elementData;
    private int size;

    public FastStatementList() {
        this.elementData = new Statement[32];
    }

    public FastStatementList(int size) {
        this.elementData = new Statement[size];
    }

    public void add(Statement element) {
        try {
            this.elementData[this.size] = element;
            ++this.size;
        }
        catch (ArrayIndexOutOfBoundsException oob) {
            int oldCapacity = this.elementData.length;
            int newCapacity = oldCapacity << 1;
            Statement[] newElementData = new Statement[newCapacity];
            System.arraycopy(this.elementData, 0, newElementData, 0, oldCapacity);
            newElementData[this.size++] = element;
            this.elementData = newElementData;
        }
    }

    public Statement get(int index) {
        return this.elementData[index];
    }

    public void remove(Object element) {
        for (int index = this.size - 1; index >= 0; --index) {
            if (element != this.elementData[index]) continue;
            int numMoved = this.size - index - 1;
            if (numMoved > 0) {
                System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
            }
            this.elementData[--this.size] = null;
            break;
        }
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }
}

