/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public final class DriverDataSource
implements DataSource {
    private final String jdbcUrl;
    private final Properties driverProperties;
    private final Driver driver;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DriverDataSource(String jdbcUrl, String driverClassName, Properties properties, String username, String password) {
        try {
            this.jdbcUrl = jdbcUrl;
            this.driverProperties = new Properties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.driverProperties.setProperty(entry.getKey().toString(), entry.getValue().toString());
            }
            if (username != null) {
                this.driverProperties.put("user", this.driverProperties.getProperty("user", username));
            }
            if (password != null) {
                this.driverProperties.put("password", this.driverProperties.getProperty("password", password));
            }
            if (driverClassName != null) {
                Driver matched = null;
                Enumeration<Driver> drivers = DriverManager.getDrivers();
                while (drivers.hasMoreElements()) {
                    Driver d = drivers.nextElement();
                    if (!d.getClass().getName().equals(driverClassName)) continue;
                    matched = d;
                    break;
                }
                if (matched == null) throw new IllegalArgumentException("Driver with class name " + driverClassName + " was not found among registered drivers");
                this.driver = matched;
                return;
            } else {
                this.driver = DriverManager.getDriver(jdbcUrl);
            }
            return;
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to get driver for JDBC URL " + jdbcUrl, e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.driver.connect(this.jdbcUrl, this.driverProperties);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.driver.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public void shutdown() {
    }
}

