/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.dataprovider.core;

import com.zebrunner.carina.dataprovider.core.impl.BaseDataProvider;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;

public class DataProviderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private DataProviderFactory() {
    }

    public static Object[][] getDataProvider(Annotation[] annotations, ITestContext context, ITestNGMethod m) {
        Map<String, String> tuidMap = Collections.synchronizedMap(new HashMap());
        Map<String, String> testNameMap = Collections.synchronizedMap(new HashMap());
        Object[][] provider = new Object[][]{};
        for (Annotation annotation : annotations) {
            Object providerObject;
            String providerClass = DataProviderFactory.findProviderClass(annotation);
            if (providerClass.isEmpty() || !((providerObject = DataProviderFactory.initDataProvider(providerClass)) instanceof BaseDataProvider)) continue;
            BaseDataProvider dataProvider = (BaseDataProvider)providerObject;
            provider = (Object[][])ArrayUtils.addAll((Object[])provider, (Object[])dataProvider.getDataProvider(annotation, context, m));
            tuidMap.putAll(dataProvider.getTuidMap());
            testNameMap.putAll(dataProvider.getTestColumnNamesMap());
        }
        DataProviderFactory.putValuesToContext(context, tuidMap, testNameMap);
        return provider;
    }

    private static synchronized void putValuesToContext(ITestContext context, Map<String, String> tuidMap, Map<String, String> testNameFromColumn) {
        Map contextTUID = (Map)context.getAttribute("TUID");
        if (contextTUID != null) {
            contextTUID.putAll(tuidMap);
        } else {
            context.setAttribute("TUID", tuidMap);
        }
        Map contextTestName = (Map)context.getAttribute("{test_name}");
        if (contextTestName != null) {
            contextTestName.putAll(testNameFromColumn);
        } else {
            context.setAttribute("{test_name}", testNameFromColumn);
        }
    }

    private static String findProviderClass(Annotation annotation) {
        Class<? extends Annotation> type = annotation.annotationType();
        String providerClass = "";
        try {
            for (Method method : type.getDeclaredMethods()) {
                if (!method.getName().equalsIgnoreCase("classname")) continue;
                providerClass = (String)method.invoke((Object)annotation, new Object[0]);
                break;
            }
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Failure on finding DataProvider class instance", (Throwable)e);
        }
        return providerClass;
    }

    private static Object initDataProvider(String providerClass) {
        Object dataProvider = null;
        try {
            Class<?> clazz = Class.forName(providerClass);
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            dataProvider = ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("DataProvider initialization failure", (Throwable)e);
        }
        return dataProvider;
    }
}

