/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.dataprovider.parser;

import com.zebrunner.carina.dataprovider.annotations.CsvDataSourceParameters;
import com.zebrunner.carina.dataprovider.annotations.XlsDataSourceParameters;
import com.zebrunner.carina.utils.exception.InvalidArgsException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestContext;

public class DSBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Map<String, String> testParams;
    private List<String> args = new ArrayList<String>();
    private List<String> uidArgs = new ArrayList<String>();
    private List<String> staticArgs = new ArrayList<String>();
    private String dsFile;
    private String xlsSheet;
    private String executeColumn;
    private String executeValue;
    private boolean spreadsheet;
    private String groupColumn;
    private String testMethodColumn;
    private boolean argsToMap;

    @Deprecated(forRemoval=true, since="1.0.0")
    public DSBean(ITestContext context) {
        this.testParams = context.getCurrentXmlTest().getAllParameters();
        if (this.testParams.keySet().stream().anyMatch(param -> param.contains("excel_ds_") && !param.equalsIgnoreCase("{excel_ds_sheet}"))) {
            LOGGER.warn("Found usage of deprecated {excel_ds_...} suite parameters, implement new approach without \"excel\" word {ds_...}");
            this.initParamsFromSuite(this.testParams, "excel");
        } else {
            this.initParamsFromSuite(this.testParams, "");
        }
        this.xlsSheet = this.testParams.get("{excel_ds_sheet}");
        this.argsToMap = this.args.isEmpty();
    }

    public DSBean(XlsDataSourceParameters xlsDataSourceParameters, Map<String, String> suiteParams) {
        if (xlsDataSourceParameters != null) {
            this.initParamsFromAnnotation(xlsDataSourceParameters);
        }
        if (!suiteParams.isEmpty()) {
            if (suiteParams.keySet().stream().anyMatch(param -> param.contains("excel_ds_") && !param.equalsIgnoreCase("{excel_ds_sheet}"))) {
                LOGGER.warn("Found usage of deprecated {excel_ds_...} suite parameters, implement new approach without \"excel\" word {ds_...}");
                this.initParamsFromSuite(suiteParams, "excel");
            } else {
                this.initParamsFromSuite(suiteParams, "");
            }
            if (suiteParams.get("{excel_ds_sheet}") != null) {
                this.xlsSheet = suiteParams.get("{excel_ds_sheet}");
            }
        }
        if (xlsDataSourceParameters != null && !xlsDataSourceParameters.spreadsheetId().isEmpty()) {
            if (!this.dsFile.isEmpty()) {
                throw new InvalidArgsException("Spreadsheet id and path parameters are mutually exclusive");
            }
            this.dsFile = xlsDataSourceParameters.spreadsheetId();
            this.spreadsheet = true;
        }
        this.testParams = suiteParams;
        this.argsToMap = this.args.isEmpty();
    }

    public DSBean(CsvDataSourceParameters csvDataSourceParameters, Map<String, String> suiteParams) {
        if (csvDataSourceParameters != null) {
            this.initParamsFromAnnotation(csvDataSourceParameters);
        }
        if (!suiteParams.isEmpty()) {
            this.initParamsFromSuite(suiteParams, "");
        }
        this.testParams = suiteParams;
        this.xlsSheet = null;
        this.argsToMap = this.args.isEmpty();
    }

    private void initParamsFromAnnotation(XlsDataSourceParameters parameters) {
        this.dsFile = parameters.path();
        this.executeColumn = parameters.executeColumn();
        this.executeValue = parameters.executeValue();
        this.groupColumn = parameters.groupColumn();
        this.testMethodColumn = parameters.testMethodColumn();
        this.xlsSheet = parameters.sheet();
        if (!parameters.dsArgs().isEmpty()) {
            this.args = Arrays.asList(parameters.dsArgs().replace(" ", "").split(","));
        }
        if (!parameters.dsUid().isEmpty()) {
            this.uidArgs = Arrays.asList(parameters.dsUid().replace(" ", "").split(","));
        }
        if (!parameters.staticArgs().isEmpty()) {
            this.staticArgs = Arrays.asList(parameters.staticArgs().replace(" ", "").split(","));
        }
    }

    private void initParamsFromAnnotation(CsvDataSourceParameters parameters) {
        this.dsFile = parameters.path();
        this.executeColumn = parameters.executeColumn();
        this.executeValue = parameters.executeValue();
        this.groupColumn = parameters.groupColumn();
        this.testMethodColumn = parameters.testMethodColumn();
        if (!parameters.dsArgs().isEmpty()) {
            this.args = Arrays.asList(parameters.dsArgs().replace(" ", "").split(","));
        }
        if (!parameters.dsUid().isEmpty()) {
            this.uidArgs = Arrays.asList(parameters.dsUid().replace(" ", "").split(","));
        }
        if (!parameters.staticArgs().isEmpty()) {
            this.staticArgs = Arrays.asList(parameters.staticArgs().replace(" ", "").split(","));
        }
    }

    private void initParamsFromSuite(Map<String, String> suiteParams, String specialKeyPrefix) {
        String dsUid;
        String dsArgs;
        if (suiteParams.get(this.insert("{ds_file}", specialKeyPrefix)) != null) {
            this.dsFile = suiteParams.get(this.insert("{ds_file}", specialKeyPrefix));
        }
        if (suiteParams.get("{ds_execute_column}") != null) {
            this.executeColumn = suiteParams.get("{ds_execute_column}");
        }
        if (suiteParams.get("{ds_execute_value}") != null) {
            this.executeValue = suiteParams.get("{ds_execute_value}");
        }
        if ((dsArgs = suiteParams.get(this.insert("{ds_args}", specialKeyPrefix))) != null && !dsArgs.isEmpty()) {
            this.args = Arrays.asList(dsArgs.replace(" ", "").split(","));
        }
        if ((dsUid = suiteParams.get(this.insert("{ds_uid}", specialKeyPrefix))) != null && !dsUid.isEmpty()) {
            this.uidArgs = Arrays.asList(dsUid.replace(" ", "").split(","));
        }
    }

    private String insert(String into, String insertion) {
        StringBuilder newString = new StringBuilder(into);
        newString.insert(1, insertion);
        return newString.toString();
    }

    public Map<String, String> getTestParams() {
        return this.testParams;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public List<String> getUidArgs() {
        return this.uidArgs;
    }

    public List<String> getStaticArgs() {
        return this.staticArgs;
    }

    public String getDsFile() {
        return this.dsFile;
    }

    public String getXlsSheet() {
        return this.xlsSheet;
    }

    public String getGroupColumn() {
        return this.groupColumn;
    }

    public String getTestMethodColumn() {
        return this.testMethodColumn;
    }

    public boolean isSpreadsheet() {
        return this.spreadsheet;
    }

    public String getExecuteColumn() {
        return this.executeColumn;
    }

    public String getExecuteValue() {
        return this.executeValue;
    }

    public boolean isArgsToMap() {
        return this.argsToMap;
    }

    public void setArgsToMap(boolean argsToMap) {
        this.argsToMap = argsToMap;
    }
}

