/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils.parser.xls;

import com.zebrunner.carina.dataprovider.DataProviderParameterGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractTable {
    protected List<String> headers = Collections.synchronizedList(new LinkedList());
    protected List<Map<String, String>> dataRows = Collections.synchronizedList(new LinkedList());
    protected String executeColumn;
    protected String executeValue;

    protected AbstractTable() {
    }

    protected AbstractTable(String executeColumn, String executeValue) {
        this();
        this.executeColumn = executeColumn;
        this.executeValue = executeValue;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public List<Map<String, String>> getDataRows() {
        return this.dataRows;
    }

    public String getExecuteColumn() {
        return this.executeColumn;
    }

    public void setExecuteColumn(String executeColumn) {
        this.executeColumn = executeColumn;
    }

    public String getExecuteValue() {
        return this.executeValue;
    }

    public void setExecuteValue(String executeValue) {
        this.executeValue = executeValue;
    }

    public void setHeaders(Collection<String> row) {
        this.headers.clear();
        this.headers.addAll(row);
    }

    public abstract void addDataRow(List<String> var1);

    public void processTable() {
        for (Map<String, String> row : this.dataRows) {
            DataProviderParameterGenerator.processMap(row);
        }
    }

    public List<List<Map<String, String>>> getGroupedDataProviderMap(String fieldName) {
        LinkedHashSet<String> groupValues = new LinkedHashSet<String>();
        for (Map<String, String> item : this.dataRows) {
            String value = item.get(fieldName);
            groupValues.add(value);
        }
        ArrayList<List<Map<String, String>>> groupedList = new ArrayList<List<Map<String, String>>>();
        for (String groupBy : groupValues) {
            ArrayList<Map<String, String>> groupOfRows = new ArrayList<Map<String, String>>();
            for (Map<String, String> item : this.dataRows) {
                String value = item.get(fieldName);
                if (!value.equals(groupBy)) continue;
                groupOfRows.add(item);
            }
            groupedList.add(groupOfRows);
        }
        return groupedList;
    }
}

