/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils.parser.xls;

import com.zebrunner.carina.utils.parser.xls.AbstractTable;
import com.zebrunner.carina.utils.parser.xls.XLSChildTable;
import com.zebrunner.carina.utils.parser.xls.XLSParser;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLSTable
extends AbstractTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String FK_PREFIX = "FK_LINK_";

    public XLSTable() {
    }

    public XLSTable(String executeColumn, String executeValue) {
        super(executeColumn, executeValue);
    }

    public void setHeaders(Row row) {
        this.headers.clear();
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            this.headers.add(XLSParser.getCellValue(row.getCell(i)));
        }
    }

    public void addDataRow(Row row, Workbook wb, Sheet sheet) {
        if (row == null) {
            return;
        }
        this.addDataRow(rowIndex -> XLSParser.getCellValue(row.getCell(rowIndex.intValue())), row, wb, sheet);
    }

    @Override
    public void addDataRow(List<String> row) {
        if (row == null) {
            return;
        }
        this.addDataRow(index -> row.size() > index ? (String)row.get((int)index) : null, null, null, null);
    }

    private void addDataRow(Function<Integer, String> cellValueGetter, Row row, Workbook wb, Sheet sheet) {
        if (this.executeColumn != null && this.executeValue != null && this.headers.contains(this.executeColumn) && !this.executeValue.equalsIgnoreCase(cellValueGetter.apply(this.headers.indexOf(this.executeColumn)))) {
            return;
        }
        XLSChildTable childRow = null;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        LOGGER.debug("Loading data from row: ");
        for (int i = 0; i < this.headers.size(); ++i) {
            String header = (String)this.headers.get(i);
            if (header.startsWith(FK_PREFIX)) {
                if (row != null && wb != null && sheet != null) {
                    childRow = XLSParser.parseCellLinks(row.getCell(i), wb, sheet);
                } else {
                    LOGGER.warn("FK_LINK_ prefix is not currently supported for spreadsheets");
                }
            }
            dataMap.put(header, cellValueGetter.apply(i));
            LOGGER.debug("{}:  {}", (Object)header, dataMap.get(header));
        }
        this.merge(childRow, dataMap);
        LOGGER.debug("Merged row: ");
        for (String header : this.headers) {
            LOGGER.debug("{}: {}", (Object)header, dataMap.get(header));
        }
        this.dataRows.add(dataMap);
    }

    private void merge(XLSChildTable childRow, Map<String, String> dataMap) {
        if (childRow != null) {
            LOGGER.debug("Loading data from child row: ");
            for (int i = 0; i < childRow.getHeaders().size(); ++i) {
                String currentHeader = childRow.getHeaders().get(i);
                if (StringUtils.isBlank((CharSequence)dataMap.get(currentHeader))) {
                    if (!this.headers.contains(currentHeader)) {
                        this.headers.add(currentHeader);
                    }
                    dataMap.put(currentHeader, childRow.getDataRows().get(0).get(currentHeader));
                }
                LOGGER.debug("{}: {}", (Object)currentHeader, (Object)childRow.getDataRows().get(0).get(currentHeader));
            }
        }
    }
}

