/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils.encryptor;

import com.zebrunner.carina.crypto.Algorithm;
import com.zebrunner.carina.crypto.SecretKeyManager;
import com.zebrunner.carina.utils.config.Configuration;
import com.zebrunner.carina.utils.config.EncryptorConfiguration;
import com.zebrunner.carina.utils.exception.InvalidConfigurationException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.LazyInitializer;

public final class EncryptorUtils {
    private static final Pattern DECRYPT_PATTERN = Pattern.compile(Configuration.get(EncryptorConfiguration.Parameter.CRYPTO_PATTERN).map(p -> {
        EncryptorUtils.validatePattern(p);
        return p;
    }).orElseThrow(() -> new InvalidConfigurationException("'crypto_pattern' parameter could not be null.")));
    private static final Pattern ENCRYPT_PATTERN = Pattern.compile("^(?<data>.+?)$");
    private static final String ENCRYPT_WRAPPER = Configuration.getRequired(EncryptorConfiguration.Parameter.CRYPTO_WRAPPER);
    private static final String DECRYPT_WRAPPER = "%s";
    private static final Algorithm ALGORITHM = Algorithm.find((String)Configuration.getRequired(EncryptorConfiguration.Parameter.CRYPTO_ALGORITHM));
    private static final ConcurrentInitializer<Key> KEY_LAZY_INITIALIZER = new LazyInitializer<Key>(){

        protected Key initialize() throws ConcurrentException {
            return SecretKeyManager.getKeyFromString((Algorithm)ALGORITHM, (String)Configuration.getRequired(EncryptorConfiguration.Parameter.CRYPTO_KEY_VALUE));
        }
    };
    private static final ThreadLocal<Cipher> CRYPTO_TOOL_ENCRYPT = ThreadLocal.withInitial(() -> {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM.getName());
            cipher.init(1, (Key)KEY_LAZY_INITIALIZER.get());
            return cipher;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException | ConcurrentException e) {
            throw new RuntimeException("Cannot create cipher instance.");
        }
    });
    private static final ThreadLocal<Cipher> CRYPTO_TOOL_DECRYPT = ThreadLocal.withInitial(() -> {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM.getName());
            cipher.init(2, (Key)KEY_LAZY_INITIALIZER.get());
            return cipher;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException | ConcurrentException e) {
            throw new RuntimeException("Cannot create cipher instance.");
        }
    });

    private EncryptorUtils() {
    }

    public static String encrypt(String str) {
        return EncryptorUtils.encrypt(str, ENCRYPT_PATTERN, ENCRYPT_WRAPPER);
    }

    public static String encrypt(String str, Pattern pattern) {
        return EncryptorUtils.encrypt(str, pattern, ENCRYPT_WRAPPER);
    }

    public static String decrypt(String str) {
        return EncryptorUtils.decrypt(str, DECRYPT_PATTERN, DECRYPT_WRAPPER);
    }

    public static String decrypt(String str, Pattern pattern) {
        return EncryptorUtils.decrypt(str, pattern, DECRYPT_WRAPPER);
    }

    public static String encrypt(String str, Pattern pattern, String wrapper) {
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            String dataToEncrypt = EncryptorUtils.getDataGroup(matcher.group(), pattern);
            if (dataToEncrypt.isEmpty()) continue;
            str = StringUtils.replace((String)str, (String)matcher.group(), (String)String.format(wrapper, EncryptorUtils.encryptSingleData(dataToEncrypt)));
        }
        return str;
    }

    public static String decrypt(String str, Pattern pattern, String wrapper) {
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            String dataToDecrypt = EncryptorUtils.getDataGroup(matcher.group(), pattern);
            if (dataToDecrypt.isEmpty()) continue;
            str = StringUtils.replace((String)str, (String)matcher.group(), (String)String.format(wrapper, EncryptorUtils.decryptSingleData(dataToDecrypt)));
        }
        return str;
    }

    public static boolean hasMatch(String str, Pattern pattern) {
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    public static void clear() {
        CRYPTO_TOOL_DECRYPT.remove();
        CRYPTO_TOOL_ENCRYPT.remove();
    }

    private static String encryptSingleData(String str) {
        try {
            return new String(Base64.encodeBase64((byte[])CRYPTO_TOOL_ENCRYPT.get().doFinal(str.getBytes())));
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException("Cannot encrypt.");
        }
    }

    private static String decryptSingleData(String str) {
        try {
            return new String(CRYPTO_TOOL_DECRYPT.get().doFinal(Base64.decodeBase64((byte[])str.getBytes())));
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getDataGroup(String str, Pattern pattern) {
        Matcher matcher = pattern.matcher(str);
        return matcher.find() ? matcher.group("data") : "";
    }

    private static void validatePattern(String pattern) {
        if (!pattern.contains("(?<data>")) {
            throw new IllegalArgumentException("There are no data group in pattern: " + pattern);
        }
    }
}

