/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.jquery.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class Generics2 {
    public static <T> ArrayList<T> newArrayList(T ... elements) {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : elements) {
            list.add(element);
        }
        return list;
    }

    public static <T> ArrayList<T> newArrayList(Iterator<? extends T> elements) {
        ArrayList list = new ArrayList();
        elements.forEachRemaining(element -> list.add(element));
        return list;
    }

    public static <T> ArrayList<T> newArrayList(Iterable<? extends T> elements) {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : elements) {
            list.add(element);
        }
        return list;
    }

    public static <T> Set<T> newLinkedHashSet(Iterable<? extends T> elements) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T element : elements) {
            set.add(element);
        }
        return set;
    }

    public static <T> Set<T> newHashSet(T ... elements) {
        HashSet<T> set = new HashSet<T>();
        for (T element : elements) {
            set.add(element);
        }
        return set;
    }

    public static String join(Iterable<?> elements, char separator) {
        StringJoiner joiner = new StringJoiner("" + separator);
        joiner.setEmptyValue("");
        for (Object element : elements) {
            joiner.add(element.toString());
        }
        return joiner.toString();
    }

    public static <T> List<T> transform(T[] elements) {
        return Generics2.newArrayList(elements);
    }

    public static <P, R> List<R> transform(List<P> elements, Function<P, R> transformer) {
        return elements.stream().map(transformer).collect(Collectors.toList());
    }

    public static <P, R> Set<R> transform(Set<P> elements, Function<P, R> transformer) {
        return elements.stream().map(transformer).collect(Collectors.toSet());
    }

    public static <P, R> List<R> transform(P[] elements, Function<P, R> transformer) {
        return Arrays.stream(elements).map(transformer).collect(Collectors.toList());
    }

    public static <T> List<T> filter(Iterable<T> unfiltered, Predicate<T> filter) {
        return Generics2.newArrayList(unfiltered).stream().filter(filter).collect(Collectors.toList());
    }

    public static List<String> split(CharSequence value, String separator) {
        StringTokenizer tokenizer = new StringTokenizer(value.toString(), separator);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    private Generics2() {
        throw new UnsupportedOperationException();
    }
}

