/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.panel;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.panel.PanelType;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Components;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class PanelBehavior
extends Behavior {
    private final IModel<PanelType> type;

    public PanelBehavior() {
        this(PanelType.Default);
    }

    public PanelBehavior(PanelType type) {
        this((IModel<PanelType>)Model.of((Serializable)((Object)type)));
    }

    public PanelBehavior(IModel<PanelType> type) {
        this.type = type;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Components.assertTag(component, tag, "div");
        for (PanelType panelType : Arrays.asList(PanelType.values())) {
            Attributes.removeClass(tag, panelType.cssClassName());
        }
        Attributes.addClass(tag, this.className(), this.getType().cssClassName());
    }

    public final PanelType getType() {
        return (PanelType)this.type.getObject();
    }

    public final PanelBehavior setType(PanelType type) {
        this.type.setObject((Object)type);
        return this;
    }

    protected String className() {
        return "panel";
    }

    public void bind(Component component) {
        super.bind(component);
        BootstrapBaseBehavior.addTo(component);
    }

    public void unbind(Component component) {
        super.unbind(component);
        BootstrapBaseBehavior.removeFrom(component);
    }
}

