/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.linux;

import de.flapdoodle.os.VersionWithPriority;
import de.flapdoodle.os.common.AllOf;
import de.flapdoodle.os.common.DistinctPeculiarity;
import de.flapdoodle.os.common.HasPecularities;
import de.flapdoodle.os.common.OneOf;
import de.flapdoodle.os.common.Peculiarity;
import de.flapdoodle.os.common.attributes.Attribute;
import de.flapdoodle.os.common.attributes.Attributes;
import de.flapdoodle.os.common.matcher.Match;
import de.flapdoodle.os.common.matcher.Matchers;
import de.flapdoodle.os.linux.OsReleaseFiles;
import java.util.List;

public enum AmazonVersion implements VersionWithPriority
{
    AmazonLinux(-1, new Peculiarity[]{AmazonVersion.osVersionMatches(".*amzn1.*")}),
    AmazonLinux2(0, new Peculiarity[]{OneOf.of((Peculiarity[])new Peculiarity[]{AllOf.of((Peculiarity[])new Peculiarity[]{OsReleaseFiles.osReleaseFileNameMatches("Amazon Linux"), OsReleaseFiles.versionMatches(OsReleaseFiles.osReleaseFile(), "2")}), AmazonVersion.osVersionMatches(".*amzn2(?!023).*")})}),
    AmazonLinux2023(1, new Peculiarity[]{OneOf.of((Peculiarity[])new Peculiarity[]{AllOf.of((Peculiarity[])new Peculiarity[]{OsReleaseFiles.osReleaseFileNameMatches("Amazon Linux"), OsReleaseFiles.versionMatches(OsReleaseFiles.osReleaseFile(), "2023")}), AmazonVersion.osVersionMatches(".*amzn2023.*")})});

    private final int priority;
    private final List<Peculiarity> peculiarities;

    private AmazonVersion(int priority, Peculiarity ... peculiarities) {
        this.priority = priority;
        this.peculiarities = HasPecularities.asList((Peculiarity[])peculiarities);
    }

    public List<Peculiarity> pecularities() {
        return this.peculiarities;
    }

    public int priority() {
        return this.priority;
    }

    static DistinctPeculiarity<String> osVersionMatches(String name) {
        return DistinctPeculiarity.of(AmazonVersion.osVersion(), (Match)Matchers.matchPattern((String)name));
    }

    static Attribute<String> osVersion() {
        return Attributes.systemProperty((String)"os.version");
    }

    public String toString() {
        return super.toString() + "(priority=" + this.priority + ")";
    }
}

