/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo;

import de.flapdoodle.embed.mongo.AbstractMongoProcess;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.runtime.Mongod;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.directories.PropertyOrPlatformTempDir;
import de.flapdoodle.embed.process.io.file.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

public class MongodProcess
extends AbstractMongoProcess<IMongodConfig, MongodExecutable, MongodProcess> {
    private static Logger logger = Logger.getLogger(MongodProcess.class.getName());
    private File dbDir;
    boolean dbDirIsTemp;

    public MongodProcess(Distribution distribution, IMongodConfig config, IRuntimeConfig runtimeConfig, MongodExecutable mongodExecutable) throws IOException {
        super(distribution, config, runtimeConfig, mongodExecutable);
    }

    protected void onBeforeProcess(IRuntimeConfig runtimeConfig) throws IOException {
        File tmpDbDir;
        super.onBeforeProcess(runtimeConfig);
        IMongodConfig config = (IMongodConfig)this.getConfig();
        if (config.replication().getDatabaseDir() != null) {
            tmpDbDir = Files.createOrCheckDir((String)config.replication().getDatabaseDir());
        } else {
            tmpDbDir = Files.createTempDir((IDirectory)PropertyOrPlatformTempDir.defaultInstance(), (String)"embedmongo-db");
            this.dbDirIsTemp = true;
        }
        this.dbDir = tmpDbDir;
    }

    protected void onBeforeProcessStart(ProcessBuilder processBuilder, IMongodConfig config, IRuntimeConfig runtimeConfig) {
        config.processListener().onBeforeProcessStart(this.dbDir, this.dbDirIsTemp);
        super.onBeforeProcessStart(processBuilder, (IExecutableProcessConfig)config, runtimeConfig);
    }

    protected void onAfterProcessStop(IMongodConfig config, IRuntimeConfig runtimeConfig) {
        super.onAfterProcessStop((IExecutableProcessConfig)config, runtimeConfig);
        config.processListener().onAfterProcessStop(this.dbDir, this.dbDirIsTemp);
    }

    protected List<String> getCommandLine(Distribution distribution, IMongodConfig config, IExtractedFileSet files) throws IOException {
        return Mongod.enhanceCommandLinePlattformSpecific(distribution, Mongod.getCommandLine((IMongodConfig)this.getConfig(), files, this.dbDir));
    }

    @Override
    protected void deleteTempFiles() {
        super.deleteTempFiles();
        if (this.dbDir != null && this.dbDirIsTemp && !Files.forceDelete((File)this.dbDir)) {
            logger.warning("Could not delete temp db dir: " + this.dbDir);
        }
    }
}

