/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.ImmutableNet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Net {
    public abstract Optional<String> getBindIp();

    public abstract int getPort();

    public abstract boolean isIpv6();

    @Value.Auxiliary
    public Net withPort(int port) {
        return ImmutableNet.copyOf(this).withPort(port);
    }

    @Value.Auxiliary
    public InetAddress getServerAddress() throws UnknownHostException {
        if (this.getBindIp().isPresent()) {
            return InetAddress.getByName(this.getBindIp().get());
        }
        return de.flapdoodle.net.Net.getLocalHost();
    }

    public static Net of(String bindIp, int port, boolean ipv6) {
        return Net.builder().bindIp(bindIp).port(port).isIpv6(ipv6).build();
    }

    public static ImmutableNet.Builder builder() {
        return ImmutableNet.builder();
    }

    public static Net defaults() {
        try {
            InetAddress localHost = de.flapdoodle.net.Net.getLocalHost();
            int freeServerPort = de.flapdoodle.net.Net.freeServerPort((InetAddress)localHost);
            boolean localhostIsIPv6 = de.flapdoodle.net.Net.localhostIsIPv6();
            return Net.builder().port(freeServerPort).isIpv6(localhostIsIPv6).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

