/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.transitions;

import de.flapdoodle.embed.mongo.transitions.PackageOfCommandDistribution;
import de.flapdoodle.embed.mongo.types.SystemEnv;
import de.flapdoodle.embed.mongo.types.SystemProperties;
import de.flapdoodle.embed.process.archives.ExtractedFileSet;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.io.directories.PersistentDir;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import de.flapdoodle.embed.process.io.progress.StandardConsoleProgressListener;
import de.flapdoodle.embed.process.store.ContentHashExtractedFileSetStore;
import de.flapdoodle.embed.process.store.DownloadCache;
import de.flapdoodle.embed.process.store.ExtractedFileSetStore;
import de.flapdoodle.embed.process.store.LocalDownloadCache;
import de.flapdoodle.embed.process.transitions.DownloadPackage;
import de.flapdoodle.embed.process.transitions.ExtractPackage;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.Transitions;
import de.flapdoodle.reverse.transitions.Derive;
import de.flapdoodle.reverse.transitions.Join;
import de.flapdoodle.reverse.transitions.Start;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.immutables.value.Value;

public interface ExtractFileSet {
    public static final String ARTIFACT_STORE_PROPERTY_NAME = "de.flapdoodle.embed.mongo.artifacts";
    public static final String ARTIFACT_STORE_ENV_NAME = "EMBEDDED_MONGO_ARTIFACTS";

    @Value.Default
    default public Transition<PersistentDir> persistentBaseDir() {
        return Join.given(SystemEnv.class).and(SystemProperties.class).state(PersistentDir.class).deriveBy((systemEnv, systemProperties) -> Optional.ofNullable(systemProperties.value().getOrDefault(ARTIFACT_STORE_PROPERTY_NAME, (String)systemEnv.value().get(ARTIFACT_STORE_ENV_NAME))).map(x$0 -> Paths.get(x$0, new String[0])).map(PersistentDir::of).orElseGet(PersistentDir.inUserHome((String)".embedmongo").mapToUncheckedException(RuntimeException::new)));
    }

    @Value.Default
    default public Transition<DownloadCache> downloadCache() {
        return Derive.given(PersistentDir.class).state(DownloadCache.class).deriveBy(storeBaseDir -> new LocalDownloadCache(((Path)storeBaseDir.value()).resolve("archives"))).withTransitionLabel("downloadCache");
    }

    @Value.Default
    default public Transition<ExtractedFileSetStore> extractedFileSetStore() {
        return Derive.given(PersistentDir.class).state(ExtractedFileSetStore.class).deriveBy(baseDir -> new ContentHashExtractedFileSetStore(((Path)baseDir.value()).resolve("fileSets"))).withTransitionLabel("extractedFileSetStore");
    }

    @Value.Default
    default public DownloadPackage downloadPackage() {
        return DownloadPackage.withDefaults();
    }

    @Value.Default
    default public Transition<ProgressListener> progressListener() {
        return Start.to(ProgressListener.class).providedBy(StandardConsoleProgressListener::new);
    }

    @Value.Default
    default public Transition<ExtractedFileSet> extractPackage() {
        return ExtractPackage.withDefaults().withExtractedFileSetStore(StateID.of(ExtractedFileSetStore.class));
    }

    @Value.Default
    default public Transition<Package> packageOfDistribution() {
        return PackageOfCommandDistribution.withDefaults();
    }

    @Value.Auxiliary
    default public Transitions extractFileSet() {
        return Transitions.from((Transition[])new Transition[]{this.persistentBaseDir(), this.downloadCache(), this.packageOfDistribution(), this.progressListener(), this.downloadPackage(), this.extractedFileSetStore(), this.extractPackage()});
    }
}

