/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.archives;

import de.flapdoodle.embed.process.archives.ExtractedFileSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class ImmutableExtractedFileSet
extends ExtractedFileSet {
    private final Path baseDir;
    private final Path executable;
    private final Set<Path> libraryFiles;

    private ImmutableExtractedFileSet(Path baseDir, Path executable, Set<Path> libraryFiles) {
        this.baseDir = baseDir;
        this.executable = executable;
        this.libraryFiles = libraryFiles;
    }

    @Override
    public Path baseDir() {
        return this.baseDir;
    }

    @Override
    public Path executable() {
        return this.executable;
    }

    @Override
    public Set<Path> libraryFiles() {
        return this.libraryFiles;
    }

    public final ImmutableExtractedFileSet withBaseDir(Path value) {
        if (this.baseDir == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "baseDir");
        return new ImmutableExtractedFileSet(newValue, this.executable, this.libraryFiles);
    }

    public final ImmutableExtractedFileSet withExecutable(Path value) {
        if (this.executable == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "executable");
        return new ImmutableExtractedFileSet(this.baseDir, newValue, this.libraryFiles);
    }

    public final ImmutableExtractedFileSet withLibraryFiles(Path ... elements) {
        Set<Path> newValue = ImmutableExtractedFileSet.createUnmodifiableSet(ImmutableExtractedFileSet.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableExtractedFileSet(this.baseDir, this.executable, newValue);
    }

    public final ImmutableExtractedFileSet withLibraryFiles(Iterable<? extends Path> elements) {
        if (this.libraryFiles == elements) {
            return this;
        }
        Set<Path> newValue = ImmutableExtractedFileSet.createUnmodifiableSet(ImmutableExtractedFileSet.createSafeList(elements, true, false));
        return new ImmutableExtractedFileSet(this.baseDir, this.executable, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExtractedFileSet && this.equalsByValue((ImmutableExtractedFileSet)another);
    }

    private boolean equalsByValue(ImmutableExtractedFileSet another) {
        return this.baseDir.equals(another.baseDir) && this.executable.equals(another.executable) && this.libraryFiles.equals(another.libraryFiles);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.baseDir.hashCode();
        h += (h << 5) + this.executable.hashCode();
        h += (h << 5) + this.libraryFiles.hashCode();
        return h;
    }

    public String toString() {
        return "ExtractedFileSet{baseDir=" + this.baseDir + ", executable=" + this.executable + ", libraryFiles=" + this.libraryFiles + "}";
    }

    public static ImmutableExtractedFileSet copyOf(ExtractedFileSet instance) {
        if (instance instanceof ImmutableExtractedFileSet) {
            return (ImmutableExtractedFileSet)instance;
        }
        return ImmutableExtractedFileSet.builder().baseDir(instance.baseDir()).executable(instance.executable()).addAllLibraryFiles(instance.libraryFiles()).build();
    }

    public static Builder builder(Path baseDir) {
        return new Builder(baseDir);
    }

    static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    public static final class Builder {
        private static final long INIT_BIT_BASE_DIR = 1L;
        private static final long INIT_BIT_EXECUTABLE = 2L;
        private long initBits = 3L;
        private Path baseDir;
        private Path executable;
        private final List<Path> libraryFiles = new ArrayList<Path>();

        private Builder(Path baseDir) {
            this.baseDir(baseDir);
        }

        private Builder() {
        }

        final Builder baseDir(Path baseDir) {
            Builder.checkNotIsSet(this.baseDirIsSet(), "baseDir");
            this.baseDir = Objects.requireNonNull(baseDir, "baseDir");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder executable(Path executable) {
            Builder.checkNotIsSet(this.executableIsSet(), "executable");
            this.executable = Objects.requireNonNull(executable, "executable");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addLibraryFiles(Path element) {
            this.libraryFiles.add(Objects.requireNonNull(element, "libraryFiles element"));
            return this;
        }

        public final Builder addLibraryFiles(Path ... elements) {
            for (Path element : elements) {
                this.libraryFiles.add(Objects.requireNonNull(element, "libraryFiles element"));
            }
            return this;
        }

        public final Builder addAllLibraryFiles(Iterable<? extends Path> elements) {
            for (Path path : elements) {
                this.libraryFiles.add(Objects.requireNonNull(path, "libraryFiles element"));
            }
            return this;
        }

        public ImmutableExtractedFileSet build() {
            this.checkRequiredAttributes();
            return new ImmutableExtractedFileSet(this.baseDir, this.executable, ImmutableExtractedFileSet.createUnmodifiableSet(this.libraryFiles));
        }

        private boolean baseDirIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean executableIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ExtractedFileSet is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.baseDirIsSet()) {
                attributes.add("baseDir");
            }
            if (!this.executableIsSet()) {
                attributes.add("executable");
            }
            return "Cannot build ExtractedFileSet, some of required attributes are not set " + attributes;
        }
    }
}

