/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.graph;

import de.flapdoodle.graph.ImmutableEdge;
import de.flapdoodle.graph.ImmutableLoop;
import de.flapdoodle.graph.ImmutableVerticesAndEdges;
import de.flapdoodle.graph.Loop;
import de.flapdoodle.graph.VerticesAndEdges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.connectivity.KosarajuStrongConnectivityInspector;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.graph.DirectedPseudograph;

public class Graphs {
    public static <V, E> DefaultDirectedGraph<V, E> filter(DefaultDirectedGraph<V, E> src, Predicate<V> filter) {
        return Graphs.filter(src, filter, v -> {}, edge -> {});
    }

    public static <V, E> DefaultDirectedGraph<V, E> filter(DefaultDirectedGraph<V, E> src, Predicate<V> filter, Consumer<V> filteredVertexConsumer, Consumer<E> filteredEdgeConsumer) {
        DefaultDirectedGraph ret = new DefaultDirectedGraph(src.getVertexSupplier(), src.getEdgeSupplier(), src.getType().isWeighted());
        src.vertexSet().forEach(v -> {
            if (filter.test(v)) {
                ret.addVertex(v);
            } else {
                filteredVertexConsumer.accept(v);
            }
        });
        src.edgeSet().forEach(edge -> {
            Object source = src.getEdgeSource(edge);
            Object target = src.getEdgeTarget(edge);
            if (filter.test(source) && filter.test(target)) {
                ret.addEdge(source, target, edge);
            } else {
                filteredEdgeConsumer.accept(edge);
            }
        });
        return ret;
    }

    public static <V, E> Collection<VerticesAndEdges<V, E>> leavesOf(DefaultDirectedGraph<V, E> src) {
        return Graphs.leavesOrRootsOf(src, true);
    }

    public static <V, E> Collection<VerticesAndEdges<V, E>> rootsOf(DefaultDirectedGraph<V, E> src) {
        return Graphs.leavesOrRootsOf(src, false);
    }

    private static <V, E> Collection<VerticesAndEdges<V, E>> leavesOrRootsOf(DefaultDirectedGraph<V, E> src, boolean leafes) {
        ArrayList<VerticesAndEdges<Object, Object>> ret = new ArrayList<VerticesAndEdges<Object, Object>>();
        ImmutableVerticesAndEdges.Builder builder = ImmutableVerticesAndEdges.builder();
        DefaultDirectedGraph<Object, Object> filtered = Graphs.filter(src, leafes ? Graphs.isLeaf(src).negate() : Graphs.isRoot(src).negate(), t -> builder.addVertices(t), e -> builder.addEdges(ImmutableEdge.of(src.getEdgeSource(e), src.getEdgeTarget(e), e)));
        ImmutableVerticesAndEdges verticesAndEdges = builder.build();
        if (!verticesAndEdges.vertices().isEmpty()) {
            ret.add(verticesAndEdges);
            ret.addAll(Graphs.leavesOrRootsOf(filtered, leafes));
        } else {
            List<Graph<V, E>> loopingSubGraph = Graphs.loopsOfGraph(src);
            Set vertexInLoopSet = loopingSubGraph.stream().flatMap(g -> g.vertexSet().stream()).collect(Collectors.toSet());
            if (!loopingSubGraph.isEmpty()) {
                DefaultDirectedGraph<Object, Object> filteredFromLoops = Graphs.filter(filtered, v -> !vertexInLoopSet.contains(v), t -> {}, e -> {});
                ImmutableVerticesAndEdges<V, E> loopingVerticesAndEdges = Graphs.verticesAndEdgesOf(Graphs.loopsOf(loopingSubGraph));
                ret.add(loopingVerticesAndEdges);
                ret.addAll(Graphs.leavesOrRootsOf(filteredFromLoops, leafes));
            }
        }
        return Collections.unmodifiableCollection(ret);
    }

    private static <V, E> ImmutableVerticesAndEdges<V, E> verticesAndEdgesOf(List<? extends Loop<V, E>> loops) {
        ImmutableVerticesAndEdges.Builder loopingVerticesAndEdgesBuilder = ImmutableVerticesAndEdges.builder();
        loops.forEach(l -> loopingVerticesAndEdgesBuilder.addAllVertices(l.vertexSet()));
        loopingVerticesAndEdgesBuilder.addAllLoops(loops);
        ImmutableVerticesAndEdges loopingVerticesAndEdges = loopingVerticesAndEdgesBuilder.build();
        return loopingVerticesAndEdges;
    }

    private static <V, E> List<? extends Loop<V, E>> loopsOf(List<Graph<V, E>> loopingSubGraph) {
        ArrayList ret = new ArrayList();
        loopingSubGraph.forEach(g -> {
            ImmutableLoop.Builder loopBuilder = ImmutableLoop.builder();
            g.edgeSet().forEach(egde -> loopBuilder.addEdges(ImmutableEdge.of(g.getEdgeSource(egde), g.getEdgeTarget(egde), egde)));
            ret.add(loopBuilder.build());
        });
        return Collections.unmodifiableList(ret);
    }

    private static <V, E> List<Graph<V, E>> loopsOfGraph(DefaultDirectedGraph<V, E> src) {
        KosarajuStrongConnectivityInspector inspector = new KosarajuStrongConnectivityInspector(src);
        List loopingSubGraph = inspector.getStronglyConnectedComponents().stream().filter(l -> l.vertexSet().size() > 1 || l.containsEdge(l.vertexSet().iterator().next(), l.vertexSet().iterator().next())).collect(Collectors.toList());
        return Collections.unmodifiableList(loopingSubGraph);
    }

    public static <V, E> List<? extends Loop<V, E>> loopsOf(DefaultDirectedGraph<V, E> src) {
        return Graphs.loopsOf(Graphs.loopsOfGraph(src));
    }

    public static <V> Predicate<V> isLeaf(DefaultDirectedGraph<V, ?> graph) {
        return v -> graph.outDegreeOf(v) == 0;
    }

    public static <V> Predicate<V> isRoot(DefaultDirectedGraph<V, ?> graph) {
        return v -> graph.inDegreeOf(v) == 0;
    }

    public static <V, E, G extends Graph<V, E>> WithGraphBuilder<V, E, G> with(Supplier<GraphBuilder<V, E, G>> graphSupplier) {
        return new WithGraphBuilder<V, E, G>(graphSupplier);
    }

    public static <V, E, G extends Graph<V, E>> Supplier<GraphBuilder<V, E, G>> graphBuilder(Supplier<G> graphSupplier) {
        return () -> GraphBuilder.of((Graph)graphSupplier.get());
    }

    public static <V> Supplier<GraphBuilder<V, DefaultEdge, DefaultDirectedGraph<V, DefaultEdge>>> directedGraphBuilder() {
        return () -> GraphBuilder.of((Graph)Graphs.directedGraph().get());
    }

    public static <V> Supplier<DefaultDirectedGraph<V, DefaultEdge>> directedGraph() {
        return Graphs.directedGraph(DefaultEdge.class);
    }

    public static <V, E> Supplier<DefaultDirectedGraph<V, E>> directedGraph(Class<? extends E> edgeClass) {
        return () -> new DefaultDirectedGraph(edgeClass);
    }

    public static <V, E> Supplier<DefaultDirectedGraph<V, E>> directedGraph(Class<V> vertexClass, Class<? extends E> edgeClass) {
        return Graphs.directedGraph(edgeClass);
    }

    public static <V, E> Supplier<DirectedMultigraph<V, DefaultEdge>> directedMultiEdgeGraph() {
        return Graphs.directedMultiEdgeGraph(DefaultEdge.class);
    }

    public static <V, E> Supplier<DirectedMultigraph<V, E>> directedMultiEdgeGraph(Class<? extends E> edgeClass) {
        return () -> new DirectedMultigraph(edgeClass);
    }

    public static <V, E> Supplier<DirectedMultigraph<V, E>> directedMultiEdgeGraph(Class<V> vertexClass, Class<? extends E> edgeClass) {
        return Graphs.directedMultiEdgeGraph(edgeClass);
    }

    public static <V, E> Supplier<DirectedPseudograph<V, DefaultEdge>> directedPseudoGraph() {
        return Graphs.directedPseudoGraph(DefaultEdge.class);
    }

    public static <V, E> Supplier<DirectedPseudograph<V, E>> directedPseudoGraph(Class<? extends E> edgeClass) {
        return () -> new DirectedPseudograph(edgeClass);
    }

    public static <V, E> Supplier<DirectedPseudograph<V, E>> directedPseudoGraph(Class<V> vertexClass, Class<? extends E> edgeClass) {
        return Graphs.directedPseudoGraph(edgeClass);
    }

    public static <V> boolean hasPath(DefaultDirectedGraph<V, ?> graph, V from, V to) {
        GraphPath paths = DijkstraShortestPath.findPathBetween(graph, from, to);
        return paths != null && !paths.getEdgeList().isEmpty();
    }

    public static class GraphBuilder<V, E, G extends Graph<V, E>> {
        private final G graph;

        public GraphBuilder(G graph) {
            this.graph = graph;
        }

        public G build() {
            return this.graph;
        }

        public GraphBuilder<V, E, G> addVertex(V v) {
            this.graph.addVertex(v);
            return this;
        }

        public GraphBuilder<V, E, G> addEdge(V a, V b) {
            this.graph.addEdge(a, b);
            return this;
        }

        public GraphBuilder<V, E, G> addEdge(V a, V b, E edge) {
            this.graph.addEdge(a, b, edge);
            return this;
        }

        public GraphBuilder<V, E, G> addVertices(V a, V b, V ... other) {
            this.graph.addVertex(a);
            this.graph.addVertex(b);
            for (V o : other) {
                this.graph.addVertex(o);
            }
            return this;
        }

        public GraphBuilder<V, E, G> addEdgeChain(V a, V b, V ... other) {
            this.addVertices(a, b, other);
            this.graph.addEdge(a, b);
            V last = b;
            for (V o : other) {
                this.graph.addEdge(last, o);
                last = o;
            }
            return this;
        }

        private static <V, E, G extends Graph<V, E>> GraphBuilder<V, E, G> of(G graph) {
            return new GraphBuilder<V, E, G>(graph);
        }
    }

    public static class WithGraphBuilder<V, E, G extends Graph<V, E>> {
        private final Supplier<GraphBuilder<V, E, G>> graphSupplier;

        public WithGraphBuilder(Supplier<GraphBuilder<V, E, G>> graphSupplier) {
            this.graphSupplier = graphSupplier;
        }

        public <T> G build(Iterable<T> src, BiConsumer<? super GraphBuilder<V, E, ?>, T> forEach) {
            GraphBuilder ret = this.graphSupplier.get();
            src.forEach(t -> forEach.accept(ret, t));
            return ret.build();
        }

        public G build(Consumer<? super GraphBuilder<V, E, ?>> graphBuilderConsumer) {
            GraphBuilder<V, E, G> ret = this.graphSupplier.get();
            graphBuilderConsumer.accept(ret);
            return ret.build();
        }
    }
}

