/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.guava;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class Sort {
    private Sort() {
    }

    public static <T extends Comparable<T>> List<T> sort(Iterable<T> source) {
        ArrayList toSort = Lists.newArrayList(source);
        Collections.sort(toSort);
        return toSort;
    }

    public static <T> List<T> sortBy(Iterable<T> source, Comparator<? super T> comparator) {
        ArrayList toSort = Lists.newArrayList(source);
        Collections.sort(toSort, comparator);
        return toSort;
    }

    public static <T, S> List<T> sortBy(Iterable<T> source, Function<T, S> sortTransformation, Comparator<? super S> comparator) {
        List result = Lists.transform((List)Lists.newArrayList(source), new EntryRefTransformation<T, S>(sortTransformation));
        List<? super S> sorted = Sort.sortBy(result, new EntryRefComparator<S>(comparator));
        return Lists.transform(sorted, new EntryRefSourceTransformation());
    }

    public static <T, S extends Comparable<S>> List<T> sortBy(Iterable<T> source, Function<T, S> sortTransformation) {
        return Sort.sortBy(source, sortTransformation, Ordering.natural());
    }

    static class EntryRef<T, S> {
        private final T source;
        private final S sortValue;

        public EntryRef(T source, S sortValue) {
            this.source = source;
            this.sortValue = sortValue;
        }

        public T source() {
            return this.source;
        }

        public S sortValue() {
            return this.sortValue;
        }
    }

    static class EntryRefComparator<S>
    implements Comparator<EntryRef<?, S>> {
        private final Comparator<? super S> comparator;

        public EntryRefComparator(Comparator<? super S> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(EntryRef<?, S> o1, EntryRef<?, S> o2) {
            return this.comparator.compare(o1.sortValue(), o2.sortValue());
        }
    }

    static class EntryRefTransformation<T, S>
    implements Function<T, EntryRef<T, S>> {
        private final Function<T, S> sortTransformation;

        public EntryRefTransformation(Function<T, S> sortTransformation) {
            this.sortTransformation = sortTransformation;
        }

        public EntryRef<T, S> apply(T input) {
            return new EntryRef<T, Object>(input, this.sortTransformation.apply(input));
        }
    }

    static class EntryRefSourceTransformation<T, S>
    implements Function<EntryRef<T, S>, T> {
        EntryRefSourceTransformation() {
        }

        public T apply(EntryRef<T, S> input) {
            return input.source();
        }
    }
}

