package de.flapdoodle.reverse;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NamedTypeAndState}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNamedTypeAndState.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableNamedTypeAndState.of()}.
 */
@Generated(from = "NamedTypeAndState", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
final class ImmutableNamedTypeAndState<T> implements NamedTypeAndState<T> {
  private final StateID<T> type;
  private final State<T> state;

  private ImmutableNamedTypeAndState(StateID<T> type, State<T> state) {
    this.type = Objects.requireNonNull(type, "type");
    this.state = Objects.requireNonNull(state, "state");
  }

  private ImmutableNamedTypeAndState(
      ImmutableNamedTypeAndState<T> original,
      StateID<T> type,
      State<T> state) {
    this.type = type;
    this.state = state;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public StateID<T> type() {
    return type;
  }

  /**
   * @return The value of the {@code state} attribute
   */
  @Override
  public State<T> state() {
    return state;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NamedTypeAndState#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNamedTypeAndState<T> withType(StateID<T> value) {
    if (this.type == value) return this;
    StateID<T> newValue = Objects.requireNonNull(value, "type");
    return new ImmutableNamedTypeAndState<>(this, newValue, this.state);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NamedTypeAndState#state() state} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNamedTypeAndState<T> withState(State<T> value) {
    if (this.state == value) return this;
    State<T> newValue = Objects.requireNonNull(value, "state");
    return new ImmutableNamedTypeAndState<>(this, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNamedTypeAndState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNamedTypeAndState<?>
        && equalTo(0, (ImmutableNamedTypeAndState<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableNamedTypeAndState<?> another) {
    return type.equals(another.type)
        && state.equals(another.state);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code state}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + state.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NamedTypeAndState} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NamedTypeAndState{"
        + "type=" + type
        + ", state=" + state
        + "}";
  }

  /**
   * Construct a new immutable {@code NamedTypeAndState} instance.
 * @param <T> generic parameter T
   * @param type The value for the {@code type} attribute
   * @param state The value for the {@code state} attribute
   * @return An immutable NamedTypeAndState instance
   */
  public static <T> ImmutableNamedTypeAndState<T> of(StateID<T> type, State<T> state) {
    return new ImmutableNamedTypeAndState<>(type, state);
  }

  /**
   * Creates an immutable copy of a {@link NamedTypeAndState} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable NamedTypeAndState instance
   */
  public static <T> ImmutableNamedTypeAndState<T> copyOf(NamedTypeAndState<T> instance) {
    if (instance instanceof ImmutableNamedTypeAndState<?>) {
      return (ImmutableNamedTypeAndState<T>) instance;
    }
    return ImmutableNamedTypeAndState.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNamedTypeAndState ImmutableNamedTypeAndState}.
   * <pre>
   * ImmutableNamedTypeAndState.&amp;lt;T&amp;gt;builder()
   *    .type(de.flapdoodle.reverse.StateID&amp;lt;T&amp;gt;) // required {@link NamedTypeAndState#type() type}
   *    .state(de.flapdoodle.reverse.State&amp;lt;T&amp;gt;) // required {@link NamedTypeAndState#state() state}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableNamedTypeAndState builder
   */
  public static <T> ImmutableNamedTypeAndState.Builder<T> builder() {
    return new ImmutableNamedTypeAndState.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableNamedTypeAndState ImmutableNamedTypeAndState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NamedTypeAndState", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_STATE = 0x2L;
    private long initBits = 0x3L;

    private StateID<T> type;
    private State<T> state;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NamedTypeAndState} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(NamedTypeAndState<T> instance) {
      Objects.requireNonNull(instance, "instance");
      this.type(instance.type());
      this.state(instance.state());
      return this;
    }

    /**
     * Initializes the value for the {@link NamedTypeAndState#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> type(StateID<T> type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link NamedTypeAndState#state() state} attribute.
     * @param state The value for state 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> state(State<T> state) {
      this.state = Objects.requireNonNull(state, "state");
      initBits &= ~INIT_BIT_STATE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNamedTypeAndState ImmutableNamedTypeAndState}.
     * @return An immutable instance of NamedTypeAndState
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNamedTypeAndState<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNamedTypeAndState<>(null, type, state);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_STATE) != 0) attributes.add("state");
      return "Cannot build NamedTypeAndState, some of required attributes are not set " + attributes;
    }
  }
}
