/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.reverse.ImmutableTransitions;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.TransitionWalker;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Transitions {
    public abstract List<Transition<?>> transitions();

    @Value.Auxiliary
    public Transitions addAll(Transition<?> ... transitions) {
        return ImmutableTransitions.builder().from(this).addTransitions(transitions).build();
    }

    public Transitions addAll(Transitions other) {
        return ImmutableTransitions.builder().from(this).addAllTransitions(other.transitions()).build();
    }

    @Value.Auxiliary
    public <T> Transitions replace(Transition<T> transition) {
        List filteredTransition = this.transitions().stream().filter(it -> !it.destination().equals(transition.destination())).collect(Collectors.toList());
        boolean transitionWithSameDestinationRemoved = filteredTransition.size() + 1 == this.transitions().size();
        Preconditions.checkArgument((boolean)transitionWithSameDestinationRemoved, (String)"no transition with destination %s found", (Object[])new Object[]{transition.destination()});
        return ImmutableTransitions.builder().transitions(filteredTransition).addTransitions((Transition<?>)transition).build();
    }

    @Value.Check
    protected void checkForCollisions() {
        Transitions.assertNoCollisions(this.transitions());
    }

    @Value.Auxiliary
    public TransitionWalker walker() {
        return TransitionWalker.with(this.transitions());
    }

    public static Transitions from(Transition<?> ... transitions) {
        return ImmutableTransitions.builder().addTransitions(transitions).build();
    }

    public static void assertNoCollisions(List<? extends Transition<?>> all) {
        String transitionWithCollisions = all.stream().collect(Collectors.groupingBy(Transition::destination)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> entry.getKey() + " --> " + entry.getValue()).collect(Collectors.joining(",\n  "));
        Preconditions.checkArgument((boolean)transitionWithCollisions.isEmpty(), (String)"multiple transitions with same destination: \n  %s", (Object[])new Object[]{transitionWithCollisions});
    }
}

