/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.jes;

import de.larssh.jes.JesException;
import de.larssh.jes.JesLimitReachedException;
import de.larssh.jes.Job;
import de.larssh.jes.JobOutput;
import de.larssh.jes.JobStatus;
import de.larssh.jes.parser.JesFtpFile;
import de.larssh.jes.parser.JesFtpFileEntryParserFactory;
import de.larssh.utils.Collectors;
import de.larssh.utils.Finals;
import de.larssh.utils.Nullables;
import de.larssh.utils.Optionals;
import de.larssh.utils.annotations.SuppressJacocoGenerated;
import de.larssh.utils.function.ThrowingConsumer;
import de.larssh.utils.function.ThrowingFunction;
import de.larssh.utils.text.Patterns;
import de.larssh.utils.text.Strings;
import de.larssh.utils.time.Stopwatch;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;

public class JesClient
implements Closeable {
    public static final String FILTER_WILDCARD = (String)Finals.constant((Object)"*");
    private static final Charset FTP_DATA_CHARSET = StandardCharsets.UTF_8;
    public static final int LIST_LIMIT_MAX = (Integer)Finals.constant((Object)1024);
    private static final int LIST_LIMIT_EXISTS = 2;
    private static final int LIST_LIMIT_MIN = 1;
    private static final Pattern PATTERN_FTP_SUBMIT_ID = Pattern.compile("^250-IT IS KNOWN TO JES AS (?<id>\\S+)", 2);
    private static final Pattern PATTERN_JCL_JOB_NAME = Pattern.compile("^//\\s*(?<name>\\S+)");
    private static final Pattern PATTERN_LIST_LIMIT = Pattern.compile("^250-JESENTRYLIMIT OF \\d+ REACHED\\. +ADDITIONAL ENTRIES NOT DISPLAYED$", 2);
    private static final Pattern PATTERN_LIST_NAMES_NO_JOBS_FOUND = Pattern.compile("^550 NO JOBS FOUND FOR ", 2);
    private static final Pattern PATTERN_STATUS = Pattern.compile("^211-(SERVER SITE VARIABLE |TIMER )?(?<key>\\S+)( VALUE)? IS (SET TO )?(?<value>\\S+?)\\.?$", 2);
    private static final String SUBMIT_REMOTE_FILE_NAME = JesClient.class.getSimpleName() + ".jcl";
    private final FTPClient ftpClient;
    private String jesOwner = FILTER_WILDCARD;

    public JesClient() {
        this.ftpClient = new FTPClient();
        this.ftpClient.setParserFactory((FTPFileEntryParserFactory)new JesFtpFileEntryParserFactory());
    }

    @SuppressJacocoGenerated(justification="this constructor cannot be mocked nicely")
    @SuppressFBWarnings(value={"PCOA_PARTIALLY_CONSTRUCTED_OBJECT_ACCESS"}, justification="see JavaDoc")
    public JesClient(String hostname, int port, String username, String password) throws IOException, JesException {
        this();
        this.ftpClient.connect(hostname, port);
        this.login(username, password);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.getFtpClient().isAvailable()) {
                this.getFtpClient().logout();
            }
        }
        finally {
            if (this.getFtpClient().isConnected()) {
                this.getFtpClient().disconnect();
            }
        }
    }

    public void delete(Job job) throws IOException, JesException {
        if (!this.getFtpClient().deleteFile(job.getId())) {
            throw new JesException(this.getFtpClient(), "Job [%s] could not be deleted.", job.getId());
        }
    }

    public void enterJesMode() throws IOException, JesException {
        if (!this.getFtpClient().sendSiteCommand("FILEtype=JES")) {
            throw new JesException(this.getFtpClient(), "Failed setting JES mode.", new Object[0]);
        }
    }

    public boolean exists(Job job, JobStatus status) throws IOException, JesException {
        this.setJesFilters(job.getName(), status, job.getOwner(), 2);
        Object[] ids = this.getListNameResults(this.getFtpClient().listNames(job.getId())).orElseThrow(() -> new JesException(this.getFtpClient(), "Retrieving job [%s] failed. Probably no FTP data connection socket could be opened.", job.getId()));
        return Optionals.ofSingle((Object[])ids).isPresent();
    }

    public Optional<Job> getJobDetails(Job job) throws IOException, JesException {
        this.setJesFilters(job.getName(), JobStatus.ALL, job.getOwner(), LIST_LIMIT_MAX);
        return Optionals.ofSingle(Arrays.stream(this.getFtpClient().listFiles(job.getId())).filter(JesFtpFile.class::isInstance).map(JesFtpFile.class::cast).map(JesFtpFile::getJob));
    }

    @SuppressFBWarnings(value={"UVA_USE_VAR_ARGS"}, justification="No varargs needed as this is for special technical reasons only.")
    private Optional<String[]> getListNameResults(@Nullable String[] names) {
        if (names == null) {
            return Patterns.find((Pattern)PATTERN_LIST_NAMES_NO_JOBS_FOUND, (CharSequence)this.getFtpClient().getReplyString()).map(matcher -> new String[0]);
        }
        return Optional.of(names);
    }

    public Map<String, String> getServerProperties() throws IOException, JesException {
        if (!FTPReply.isPositiveCompletion((int)this.getFtpClient().stat())) {
            throw new JesException(this.getFtpClient(), "Failed executing STAT command.", new Object[0]);
        }
        String[] lines = this.getFtpClient().getReplyStrings();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (String line : lines) {
            Optional matcher = Patterns.matches((Pattern)PATTERN_STATUS, (CharSequence)line);
            if (!matcher.isPresent()) continue;
            String key = ((Matcher)matcher.get()).group("key");
            if (properties.containsKey(key)) {
                throw new JesException("Found duplicate status key \"%s\".", key);
            }
            properties.put(key, ((Matcher)matcher.get()).group("value"));
        }
        return properties;
    }

    public List<Job> list(String nameFilter) throws IOException, JesException {
        return this.list(nameFilter, JobStatus.ALL);
    }

    public List<Job> list(String nameFilter, JobStatus status) throws IOException, JesException {
        return this.list(nameFilter, status, FILTER_WILDCARD);
    }

    public List<Job> list(String nameFilter, JobStatus status, String ownerFilter) throws IOException, JesException {
        return this.list(nameFilter, status, ownerFilter, LIST_LIMIT_MAX);
    }

    public List<Job> list(String nameFilter, JobStatus status, String ownerFilter, int limit) throws IOException, JesException {
        this.setJesFilters(nameFilter, status, ownerFilter, limit);
        String[] ids = this.getListNameResults(this.getFtpClient().listNames()).orElseThrow(() -> new JesException(this.getFtpClient(), "Retrieving the list of job IDs failed. Probably no FTP data connection socket could be opened.", new Object[0]));
        return this.throwIfLimitReached(limit, Arrays.stream(ids).map(id -> new Job((String)id, nameFilter, status, ownerFilter)).collect(java.util.stream.Collectors.toList()));
    }

    public List<Job> listFilled(String nameFilter) throws IOException, JesException {
        return this.listFilled(nameFilter, JobStatus.ALL);
    }

    public List<Job> listFilled(String nameFilter, JobStatus status) throws IOException, JesException {
        return this.listFilled(nameFilter, status, FILTER_WILDCARD);
    }

    public List<Job> listFilled(String nameFilter, JobStatus status, String ownerFilter) throws IOException, JesException {
        return this.listFilled(nameFilter, status, ownerFilter, LIST_LIMIT_MAX);
    }

    public List<Job> listFilled(String nameFilter, JobStatus status, String ownerFilter, int limit) throws IOException, JesException {
        this.setJesFilters(nameFilter, status, ownerFilter, limit);
        FTPFile[] files = this.getFtpClient().listFiles();
        return this.throwIfLimitReached(limit, Arrays.stream(files).filter(JesFtpFile.class::isInstance).map(JesFtpFile.class::cast).map(JesFtpFile::getJob).collect(java.util.stream.Collectors.toList()));
    }

    public void login(String username, String password) throws IOException, JesException {
        if (!this.getFtpClient().login(username, password)) {
            throw new JesException(this.getFtpClient(), "Could not login user [%s].", username);
        }
        this.setJesOwner(username);
        this.enterJesMode();
    }

    public String retrieve(JobOutput jobOutput) throws IOException, JesException {
        String fileName = Strings.format((String)"%s.%d", (Object[])new Object[]{jobOutput.getJob().getId(), jobOutput.getIndex()});
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            if (!this.getFtpClient().retrieveFile(fileName, (OutputStream)outputStream)) {
                throw new JesException(this.getFtpClient(), "Could not retrieve data of job output [%s.%s].", jobOutput.getJob().getId(), jobOutput.getStep());
            }
            String string = new String(outputStream.toByteArray(), FTP_DATA_CHARSET);
            return string;
        }
    }

    public Map<JobOutput, String> retrieveOutputs(Job job) throws IOException, JesException {
        if (job.getOutputs().isEmpty()) {
            return this.retrieveOutputs(this.getJobDetails(job).orElseThrow(() -> new JesException("Job [%s] is not available.", job.getId())));
        }
        return (Map)job.getOutputs().stream().collect(Collectors.toLinkedHashMap(Function.identity(), (Function)ThrowingFunction.throwing(this::retrieve)));
    }

    protected void setJesFilters(String nameFilter, JobStatus status, String ownerFilter, int limit) throws IOException, JesException {
        if (!this.getFtpClient().sendSiteCommand("JESJOBName=" + nameFilter)) {
            throw new JesException(this.getFtpClient(), "Failed setting JES job name filter to [%s].", nameFilter);
        }
        if (!this.getFtpClient().sendSiteCommand("JESOwner=" + ownerFilter)) {
            throw new JesException(this.getFtpClient(), "Failed setting JES job owner filter to [%s].", ownerFilter);
        }
        if (!this.getFtpClient().sendSiteCommand("JESSTatus=" + status.getValue())) {
            throw new JesException(this.getFtpClient(), "Failed setting JES job status filter to [%s].", status.getValue());
        }
        if (!this.getFtpClient().sendSiteCommand("JESENTRYLIMIT=" + limit)) {
            throw new JesException(this.getFtpClient(), "Failed setting JES entry limit to %d. Minimum/Maximum: %d/%d", limit, 1, LIST_LIMIT_MAX);
        }
    }

    public void setJesOwner(String jesOwner) {
        this.jesOwner = Strings.toUpperCaseNeutral((String)jesOwner).trim();
    }

    public Job submit(String jclContent) throws IOException, JesException {
        try (ReaderInputStream inputStream = ((ReaderInputStream.Builder)ReaderInputStream.builder().setReader((Reader)new StringReader(jclContent))).setCharset(FTP_DATA_CHARSET).get();){
            if (!this.getFtpClient().storeUniqueFile(SUBMIT_REMOTE_FILE_NAME, (InputStream)inputStream)) {
                throw new JesException(this.getFtpClient(), "Submitting JCL failed.", new Object[0]);
            }
        }
        String jobId = Patterns.find((Pattern)PATTERN_FTP_SUBMIT_ID, (CharSequence)this.getFtpClient().getReplyString()).map(matcher -> matcher.group("id")).orElseThrow(() -> new JesException(this.getFtpClient(), "Started job, but could not extract its ID.", new Object[0]));
        String name = Patterns.find((Pattern)PATTERN_JCL_JOB_NAME, (CharSequence)jclContent).map(matcher -> matcher.group("name")).orElse(FILTER_WILDCARD);
        return new Job(jobId, name, JobStatus.INPUT, this.getJesOwner());
    }

    protected List<Job> throwIfLimitReached(int limit, List<Job> jobs) throws JesLimitReachedException {
        if (Strings.find((CharSequence)this.getFtpClient().getReplyString(), (Pattern)PATTERN_LIST_LIMIT)) {
            throw new JesLimitReachedException(limit, jobs, this.getFtpClient());
        }
        return jobs;
    }

    public boolean waitFor(Job job, Duration waiting, Duration timeout) throws InterruptedException, IOException, JesException {
        return this.waitFor(job, waiting, timeout, ThrowingConsumer.throwing(duration -> Thread.sleep(((Duration)Nullables.orElseThrow((Object)duration)).toMillis())));
    }

    public boolean waitFor(Job job, Duration waiting, Duration timeout, Consumer<Duration> wait) throws IOException, JesException {
        if (job.getStatus() == JobStatus.OUTPUT) {
            return true;
        }
        List<JobStatus> stati = job.getStatus() == JobStatus.ACTIVE ? Collections.singletonList(JobStatus.ACTIVE) : Arrays.asList(JobStatus.INPUT, JobStatus.ACTIVE);
        Stopwatch stopwatch = new Stopwatch();
        for (JobStatus status : stati) {
            while (this.exists(job, status)) {
                if (stopwatch.waitFor(waiting, timeout, wait)) continue;
                return false;
            }
        }
        return true;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public FTPClient getFtpClient() {
        return this.ftpClient;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getJesOwner() {
        return this.jesOwner;
    }
}

