/*
 * Decompiled with CFR 0.152.
 */
package de.larssh.jes;

import de.larssh.jes.Job;
import de.larssh.jes.JobFieldInconsistentException;
import de.larssh.utils.annotations.SuppressJacocoGenerated;
import de.larssh.utils.text.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;

public class JobOutput {
    private final Job job;
    private final int index;
    private final String name;
    private final int length;
    private final Optional<String> step;
    private final Optional<String> procedureStep;
    private final Optional<String> outputClass;

    protected JobOutput(Job job, int index, String name, int length, Optional<String> step, Optional<String> procedureStep, Optional<String> outputClass) {
        this.job = job;
        this.index = index;
        this.name = Strings.toUpperCaseNeutral((String)name.trim());
        this.length = length;
        this.step = step.map(String::trim).map(Strings::toUpperCaseNeutral);
        this.procedureStep = procedureStep.map(String::trim).map(Strings::toUpperCaseNeutral);
        this.outputClass = outputClass.map(String::trim).map(Strings::toUpperCaseNeutral);
        this.validate();
    }

    @SuppressJacocoGenerated(justification="private method, used for toString only")
    private String getJobId() {
        return this.getJob().getId();
    }

    private void validate() {
        if (this.index < 1) {
            throw new JobFieldInconsistentException("Index must not be less than one.", new Object[0]);
        }
        if (this.name.isEmpty()) {
            throw new JobFieldInconsistentException("Name must not be empty.", new Object[0]);
        }
        if (this.length < 0) {
            throw new JobFieldInconsistentException("Length must not be less than zero.", new Object[0]);
        }
        if (this.step.filter(String::isEmpty).isPresent()) {
            throw new JobFieldInconsistentException("Step must not be empty if present.", new Object[0]);
        }
        if (this.procedureStep.filter(String::isEmpty).isPresent()) {
            throw new JobFieldInconsistentException("Procedure Step must not be empty if present.", new Object[0]);
        }
        if (this.outputClass.filter(String::isEmpty).isPresent()) {
            throw new JobFieldInconsistentException("Output class must not be empty if present.", new Object[0]);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Job getJob() {
        return this.job;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getIndex() {
        return this.index;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getLength() {
        return this.length;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<String> getStep() {
        return this.step;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<String> getProcedureStep() {
        return this.procedureStep;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Optional<String> getOutputClass() {
        return this.outputClass;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "JobOutput(job.id=" + this.getJobId() + ", index=" + this.getIndex() + ", name=" + this.getName() + ", length=" + this.getLength() + ", step=" + this.getStep() + ", procedureStep=" + this.getProcedureStep() + ", outputClass=" + this.getOutputClass() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobOutput)) {
            return false;
        }
        JobOutput other = (JobOutput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        Job this$job = this.getJob();
        Job other$job = other.getJob();
        return !(this$job == null ? other$job != null : !((Object)this$job).equals(other$job));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof JobOutput;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        Job $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : ((Object)$job).hashCode());
        return result;
    }
}

