/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.ExpressionNode;
import java.lang.reflect.Method;
import javax.el.ELContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AstNode
implements ExpressionNode {
    @Override
    public final Object getValue(Bindings bindings, ELContext context, Class<?> type) {
        Object value = this.eval(bindings, context);
        if (type != null) {
            value = bindings.convert(value, type);
        }
        return value;
    }

    public abstract void appendStructure(StringBuilder var1, Bindings var2);

    public abstract Object eval(Bindings var1, ELContext var2);

    @Override
    public final String getStructuralId(Bindings bindings) {
        StringBuilder builder = new StringBuilder();
        this.appendStructure(builder, bindings);
        return builder.toString();
    }

    protected Method findAccessibleMethod(Method method) {
        if (method == null || method.isAccessible()) {
            return method;
        }
        try {
            method.setAccessible(true);
        }
        catch (SecurityException e) {
            for (Class<?> cls : method.getDeclaringClass().getInterfaces()) {
                Method mth = null;
                try {
                    mth = cls.getMethod(method.getName(), method.getParameterTypes());
                    mth = this.findAccessibleMethod(mth);
                    if (mth == null) continue;
                    return mth;
                }
                catch (NoSuchMethodException ignore) {
                    // empty catch block
                }
            }
            Class<?> cls = method.getDeclaringClass().getSuperclass();
            if (cls != null) {
                Method mth = null;
                try {
                    mth = cls.getMethod(method.getName(), method.getParameterTypes());
                    mth = this.findAccessibleMethod(mth);
                    if (mth != null) {
                        return mth;
                    }
                }
                catch (NoSuchMethodException ignore) {
                    // empty catch block
                }
            }
            return null;
        }
        return method;
    }
}

