/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;

class AddressResolver {
    private final String hostname;
    private final AtomicInteger cnt;

    AddressResolver(String hostname) {
        this(hostname, new AtomicInteger());
    }

    AddressResolver(String hostname, AtomicInteger cnt) {
        this.hostname = hostname;
        this.cnt = cnt;
    }

    public InetAddress resolve() throws UnknownHostException {
        InetAddress[] ips = this.lookup();
        return ips[AddressResolver.modulo(this.cnt.getAndIncrement(), ips.length)];
    }

    InetAddress[] lookup() throws UnknownHostException {
        return InetAddress.getAllByName(this.hostname);
    }

    private static int modulo(int value, int modulo) {
        return (value % modulo + modulo) % modulo;
    }
}

